/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.FileReader;
import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.rules.XPathRule;

public class XPathTest {
    public static void main(String[] args) throws Exception {
        String xpath = args[0].equals("-xpath") ? args[1] : args[3];
        String filename = args[0].equals("-file") ? args[1] : args[3];
        PMD pmd = new PMD();
        XPathRule rule = new XPathRule();
        rule.addProperty("xpath", xpath);
        rule.setMessage("Got one!");
        RuleSet ruleSet = new RuleSet();
        ruleSet.addRule(rule);
        Report report = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename(filename);
        pmd.processFile(new FileReader(filename), new RuleSets(ruleSet), ctx, SourceType.JAVA_15);
        Iterator<IRuleViolation> i = report.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = i.next();
            String res = "Match at line " + rv.getBeginLine() + " column " + rv.getBeginColumn();
            if (rv.getPackageName() != null && !rv.getPackageName().equals("")) {
                res = res + "; package name '" + rv.getPackageName() + "'";
            }
            if (rv.getMethodName() != null && !rv.getMethodName().equals("")) {
                res = res + "; method name '" + rv.getMethodName() + "'";
            }
            if (rv.getVariableName() != null && !rv.getVariableName().equals("")) {
                res = res + "; variable name '" + rv.getVariableName() + "'";
            }
            System.out.println(res);
        }
    }
}

