/**
 * <h1>AWS APIGatewayv2 Integrations</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h2>Table of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#http-apis">HTTP APIs</a>
 * <p>
 * <ul>
 * <li><a href="#lambda">Lambda Integration</a></li>
 * <li><a href="#http-proxy">HTTP Proxy Integration</a></li>
 * <li><a href="#private-integration">Private Integration</a></li>
 * </ul></li>
 * <li><a href="#websocket-apis">WebSocket APIs</a>
 * <p>
 * <ul>
 * <li><a href="#lambda-websocket-integration">Lambda WebSocket Integration</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * <h2>HTTP APIs</h2>
 * <p>
 * Integrations connect a route to backend resources. HTTP APIs support Lambda proxy, AWS service, and HTTP proxy integrations. HTTP proxy integrations are also known as private integrations.
 * <p>
 * <h3>Lambda</h3>
 * <p>
 * Lambda integrations enable integrating an HTTP API route with a Lambda function. When a client invokes the route, the
 * API Gateway service forwards the request to the Lambda function and returns the function's response to the client.
 * <p>
 * The API Gateway service will invoke the lambda function with an event payload of a specific format. The service expects
 * the function to respond in a specific format. The details on this format is available at <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda
 * proxy integrations</a>.
 * <p>
 * The following code configures a route <code>GET /books</code> with a Lambda proxy integration.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Function booksFn = new Function(stack, "BooksDefaultFn", new FunctionProps()...);
 * Object booksIntegration = LambdaProxyIntegration.Builder.create()
 *         .handler(booksDefaultFn)
 *         .build();
 * 
 * Object httpApi = new HttpApi(stack, "HttpApi");
 * 
 * httpApi.addRoutes(Map.of(
 *         "path", "/books",
 *         "methods", asList(HttpMethod.getGET()),
 *         "integration", booksIntegration));
 * </pre></blockquote>
 * <p>
 * <h3>HTTP Proxy</h3>
 * <p>
 * HTTP Proxy integrations enables connecting an HTTP API route to a publicly routable HTTP endpoint. When a client
 * invokes the route, the API Gateway service forwards the entire request and response between the API Gateway endpoint
 * and the integrating HTTP endpoint. More information can be found at <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-http.html">Working with HTTP proxy
 * integrations</a>.
 * <p>
 * The following code configures a route <code>GET /books</code> with an HTTP proxy integration to an HTTP endpoint
 * <code>get-books-proxy.myproxy.internal</code>.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object booksIntegration = HttpProxyIntegration.Builder.create()
 *         .url("https://get-books-proxy.myproxy.internal")
 *         .build();
 * 
 * Object httpApi = new HttpApi(stack, "HttpApi");
 * 
 * httpApi.addRoutes(Map.of(
 *         "path", "/books",
 *         "methods", asList(HttpMethod.getGET()),
 *         "integration", booksIntegration));
 * </pre></blockquote>
 * <p>
 * <h3>Private Integration</h3>
 * <p>
 * Private integrations enable integrating an HTTP API route with private resources in a VPC, such as Application Load Balancers or
 * Amazon ECS container-based applications.  Using private integrations, resources in a VPC can be exposed for access by
 * clients outside of the VPC.
 * <p>
 * The following integrations are supported for private resources in a VPC.
 * <p>
 * <h4>Application Load Balancer</h4>
 * <p>
 * The following code is a basic application load balancer private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = new Vpc(stack, "VPC");
 * Object lb = ALB.Builder.create(stack, "lb").vpc(vpc).build();
 * Object listener = lb.addListener("listener", Map.of("port", 80));
 * listener.addTargets("target", Map.of(
 *         "port", 80));
 * 
 * Object httpEndpoint = HttpApi.Builder.create(stack, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create()
 *                 .listener(listener)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * When an imported load balancer is used, the <code>vpc</code> option must be specified for <code>HttpAlbIntegration</code>.
 * <p>
 * <h4>Network Load Balancer</h4>
 * <p>
 * The following code is a basic network load balancer private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = new Vpc(stack, "VPC");
 * Object lb = NLB.Builder.create(stack, "lb").vpc(vpc).build();
 * Object listener = lb.addListener("listener", Map.of("port", 80));
 * listener.addTargets("target", Map.of(
 *         "port", 80));
 * 
 * Object httpEndpoint = HttpApi.Builder.create(stack, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpNlbIntegration.Builder.create()
 *                 .listener(listener)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * When an imported load balancer is used, the <code>vpc</code> option must be specified for <code>HttpNlbIntegration</code>.
 * <p>
 * <h4>Cloud Map Service Discovery</h4>
 * <p>
 * The following code is a basic discovery service private integration of HTTP API:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object vpc = new Vpc(stack, "VPC");
 * Object vpcLink = VpcLink.Builder.create(stack, "VpcLink").vpc(vpc).build();
 * Object namespace = PrivateDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("boobar.com")
 *         .vpc(vpc)
 *         .build();
 * Object service = namespace.createService("Service");
 * 
 * Object httpEndpoint = HttpApi.Builder.create(stack, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpServiceDiscoveryIntegration.Builder.create()
 *                 .vpcLink(vpcLink)
 *                 .service(service)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>WebSocket APIs</h2>
 * <p>
 * WebSocket integrations connect a route to backend resources. The following integrations are supported in the CDK.
 * <p>
 * <h3>Lambda WebSocket Integration</h3>
 * <p>
 * Lambda integrations enable integrating a WebSocket API route with a Lambda function. When a client connects/disconnects
 * or sends message specific to a route, the API Gateway service forwards the request to the Lambda function
 * <p>
 * The API Gateway service will invoke the lambda function with an event payload of a specific format.
 * <p>
 * The following code configures a <code>sendmessage</code> route with a Lambda integration
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Object webSocketApi = new WebSocketApi(stack, "mywsapi");
 * WebSocketStage.Builder.create(stack, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * 
 * Function messageHandler = new Function(stack, "MessageHandler", new FunctionProps()...);
 * webSocketApi.addRoute("sendmessage", Map.of(
 *         "integration", LambdaWebSocketIntegration.Builder.create()
 *                 .handler(connectHandler)
 *                 .build()));
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.apigatewayv2.integrations;
