package software.amazon.awscdk.services.cognito;

/**
 * Options to create a UserPoolResourceServer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:22.678Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolResourceServerOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolResourceServerOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolResourceServerOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique resource server identifier for the resource server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

    /**
     * Oauth scopes.
     * <p>
     * Default: - No scopes will be added
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> getScopes() {
        return null;
    }

    /**
     * A friendly name for the resource server.
     * <p>
     * Default: - same as `identifier`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolResourceServerName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolResourceServerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolResourceServerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolResourceServerOptions> {
        private java.lang.String identifier;
        private java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> scopes;
        private java.lang.String userPoolResourceServerName;

        /**
         * Sets the value of {@link UserPoolResourceServerOptions#getIdentifier}
         * @param identifier A unique resource server identifier for the resource server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolResourceServerOptions#getScopes}
         * @param scopes Oauth scopes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scopes(java.util.List<? extends software.amazon.awscdk.services.cognito.ResourceServerScope> scopes) {
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope>)scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolResourceServerOptions#getUserPoolResourceServerName}
         * @param userPoolResourceServerName A friendly name for the resource server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolResourceServerName(java.lang.String userPoolResourceServerName) {
            this.userPoolResourceServerName = userPoolResourceServerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolResourceServerOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolResourceServerOptions build() {
            return new Jsii$Proxy(identifier, scopes, userPoolResourceServerName);
        }
    }

    /**
     * An implementation for {@link UserPoolResourceServerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolResourceServerOptions {
        private final java.lang.String identifier;
        private final java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> scopes;
        private final java.lang.String userPoolResourceServerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ResourceServerScope.class)));
            this.userPoolResourceServerName = software.amazon.jsii.Kernel.get(this, "userPoolResourceServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String identifier, final java.util.List<? extends software.amazon.awscdk.services.cognito.ResourceServerScope> scopes, final java.lang.String userPoolResourceServerName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identifier = java.util.Objects.requireNonNull(identifier, "identifier is required");
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope>)scopes;
            this.userPoolResourceServerName = userPoolResourceServerName;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> getScopes() {
            return this.scopes;
        }

        @Override
        public final java.lang.String getUserPoolResourceServerName() {
            return this.userPoolResourceServerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identifier", om.valueToTree(this.getIdentifier()));
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            if (this.getUserPoolResourceServerName() != null) {
                data.set("userPoolResourceServerName", om.valueToTree(this.getUserPoolResourceServerName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolResourceServerOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolResourceServerOptions.Jsii$Proxy that = (UserPoolResourceServerOptions.Jsii$Proxy) o;

            if (!identifier.equals(that.identifier)) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            return this.userPoolResourceServerName != null ? this.userPoolResourceServerName.equals(that.userPoolResourceServerName) : that.userPoolResourceServerName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identifier.hashCode();
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPoolResourceServerName != null ? this.userPoolResourceServerName.hashCode() : 0);
            return result;
        }
    }
}
