package software.amazon.awscdk.services.cognito;

/**
 * Constraints that can be applied to a custom attribute of any type.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:07:51.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.CustomAttributeProps")
@software.amazon.jsii.Jsii.Proxy(CustomAttributeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomAttributeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the value of the attribute can be changed.
     * <p>
     * For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomAttributeProps> {
        private java.lang.Boolean mutable;

        /**
         * Sets the value of {@link CustomAttributeProps#getMutable}
         * @param mutable Specifies whether the value of the attribute can be changed.
         *                For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
         *                Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         *                If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomAttributeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomAttributeProps build() {
            return new Jsii$Proxy(mutable);
        }
    }

    /**
     * An implementation for {@link CustomAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAttributeProps {
        private final java.lang.Boolean mutable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean mutable) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mutable = mutable;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.CustomAttributeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomAttributeProps.Jsii$Proxy that = (CustomAttributeProps.Jsii$Proxy) o;

            return this.mutable != null ? this.mutable.equals(that.mutable) : that.mutable == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mutable != null ? this.mutable.hashCode() : 0;
            return result;
        }
    }
}
