package software.amazon.awscdk.services.cognito;

/**
 * The different ways in which a user pool's MFA enforcement can be configured.
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:07:51.618Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.Mfa")
public enum Mfa {
    /**
     * Users are not required to use MFA for sign in, and cannot configure one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OFF,
    /**
     * Users are not required to use MFA for sign in, but can configure one if they so choose to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
    /**
     * Users are required to configure an MFA, and have to use it to sign in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
}
