package software.amazon.awscdk.services.cognito;

/**
 * The different ways in which a user pool can obtain their MFA token for sign in.
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:16.065Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.MfaSecondFactor")
@software.amazon.jsii.Jsii.Proxy(MfaSecondFactor.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MfaSecondFactor extends software.amazon.jsii.JsiiSerializable {

    /**
     * The MFA token is a time-based one time password that is generated by a hardware or software token.
     * <p>
     * Default: false
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-totp.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getOtp();

    /**
     * The MFA token is sent to the user via SMS to their verified phone numbers.
     * <p>
     * Default: true
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-text-message.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getSms();

    /**
     * @return a {@link Builder} of {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MfaSecondFactor> {
        private java.lang.Boolean otp;
        private java.lang.Boolean sms;

        /**
         * Sets the value of {@link MfaSecondFactor#getOtp}
         * @param otp The MFA token is a time-based one time password that is generated by a hardware or software token. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder otp(java.lang.Boolean otp) {
            this.otp = otp;
            return this;
        }

        /**
         * Sets the value of {@link MfaSecondFactor#getSms}
         * @param sms The MFA token is sent to the user via SMS to their verified phone numbers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sms(java.lang.Boolean sms) {
            this.sms = sms;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MfaSecondFactor}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MfaSecondFactor build() {
            return new Jsii$Proxy(otp, sms);
        }
    }

    /**
     * An implementation for {@link MfaSecondFactor}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MfaSecondFactor {
        private final java.lang.Boolean otp;
        private final java.lang.Boolean sms;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.otp = software.amazon.jsii.Kernel.get(this, "otp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean otp, final java.lang.Boolean sms) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.otp = java.util.Objects.requireNonNull(otp, "otp is required");
            this.sms = java.util.Objects.requireNonNull(sms, "sms is required");
        }

        @Override
        public final java.lang.Boolean getOtp() {
            return this.otp;
        }

        @Override
        public final java.lang.Boolean getSms() {
            return this.sms;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("otp", om.valueToTree(this.getOtp()));
            data.set("sms", om.valueToTree(this.getSms()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.MfaSecondFactor"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MfaSecondFactor.Jsii$Proxy that = (MfaSecondFactor.Jsii$Proxy) o;

            if (!otp.equals(that.otp)) return false;
            return this.sms.equals(that.sms);
        }

        @Override
        public final int hashCode() {
            int result = this.otp.hashCode();
            result = 31 * result + (this.sms.hashCode());
            return result;
        }
    }
}
