package software.amazon.awscdk.services.cognito;

/**
 * OAuth scopes that are allowed with this client.
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-app-idp-settings.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:16.066Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.OAuthScope")
public class OAuthScope extends software.amazon.jsii.JsiiObject {

    protected OAuthScope(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OAuthScope(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        COGNITO_ADMIN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.OAuthScope.class, "COGNITO_ADMIN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class));
        EMAIL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.OAuthScope.class, "EMAIL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class));
        OPENID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.OAuthScope.class, "OPENID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class));
        PHONE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.OAuthScope.class, "PHONE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class));
        PROFILE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.OAuthScope.class, "PROFILE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class));
    }

    /**
     * Custom scope is one that you define for your own resource server in the Resource Servers.
     * <p>
     * The format is 'resource-server-identifier/scope'.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-define-resource-servers.html
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.OAuthScope custom(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.OAuthScope.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Adds a custom scope that's tied to a resource server in your stack.
     * <p>
     * @param server This parameter is required.
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.OAuthScope resourceServer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolResourceServer server, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ResourceServerScope scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.OAuthScope.class, "resourceServer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthScope.class), new Object[] { java.util.Objects.requireNonNull(server, "server is required"), java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Grants access to Amazon Cognito User Pool API operations that require access tokens, such as UpdateUserAttributes and VerifyUserAttribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.OAuthScope COGNITO_ADMIN;

    /**
     * Grants access to the 'email' and 'email_verified' claims.
     * <p>
     * Automatically includes access to <code>OAuthScope.OPENID</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.OAuthScope EMAIL;

    /**
     * Returns all user attributes in the ID token that are readable by the client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.OAuthScope OPENID;

    /**
     * Grants access to the 'phone_number' and 'phone_number_verified' claims.
     * <p>
     * Automatically includes access to <code>OAuthScope.OPENID</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.OAuthScope PHONE;

    /**
     * Grants access to all user attributes that are readable by the client Automatically includes access to `OAuthScope.OPENID`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.OAuthScope PROFILE;

    /**
     * The name of this scope as recognized by CloudFormation.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html#cfn-cognito-userpoolclient-allowedoauthscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScopeName() {
        return software.amazon.jsii.Kernel.get(this, "scopeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
