package software.amazon.awscdk.services.cognito;

/**
 * Props for UserPoolDomain construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:16.087Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.UserPoolDomainProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolDomainProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolDomainOptions {

    /**
     * The user pool to which this domain should be associated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * @return a {@link Builder} of {@link UserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolDomainProps> {
        private software.amazon.awscdk.services.cognito.IUserPool userPool;
        private software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        private software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Sets the value of {@link UserPoolDomainProps#getUserPool}
         * @param userPool The user pool to which this domain should be associated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolDomainProps#getCognitoDomain}
         * @param cognitoDomain Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoDomain(software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain) {
            this.cognitoDomain = cognitoDomain;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolDomainProps#getCustomDomain}
         * @param customDomain Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomain(software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolDomainProps build() {
            return new Jsii$Proxy(userPool, cognitoDomain, customDomain);
        }
    }

    /**
     * An implementation for {@link UserPoolDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolDomainProps {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        private final software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.cognitoDomain = software.amazon.jsii.Kernel.get(this, "cognitoDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.CognitoDomainOptions.class));
            this.customDomain = software.amazon.jsii.Kernel.get(this, "customDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.CustomDomainOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.cognito.IUserPool userPool, final software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain, final software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(userPool, "userPool is required");
            this.cognitoDomain = cognitoDomain;
            this.customDomain = customDomain;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.CognitoDomainOptions getCognitoDomain() {
            return this.cognitoDomain;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.CustomDomainOptions getCustomDomain() {
            return this.customDomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getCognitoDomain() != null) {
                data.set("cognitoDomain", om.valueToTree(this.getCognitoDomain()));
            }
            if (this.getCustomDomain() != null) {
                data.set("customDomain", om.valueToTree(this.getCustomDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.UserPoolDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolDomainProps.Jsii$Proxy that = (UserPoolDomainProps.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            if (this.cognitoDomain != null ? !this.cognitoDomain.equals(that.cognitoDomain) : that.cognitoDomain != null) return false;
            return this.customDomain != null ? this.customDomain.equals(that.customDomain) : that.customDomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.cognitoDomain != null ? this.cognitoDomain.hashCode() : 0);
            result = 31 * result + (this.customDomain != null ? this.customDomain.hashCode() : 0);
            return result;
        }
    }
}
