package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties to define a network load balancer target group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:26.528Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.NetworkTargetProps")
@software.amazon.jsii.Jsii.Proxy(NetworkTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port number of the container.
     * <p>
     * Only applicable when using application/network load balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getContainerPort();

    /**
     * Name of the listener the target group attached to.
     * <p>
     * Default: - default listener (first added listener)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getListener() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkTargetProps> {
        private java.lang.Number containerPort;
        private java.lang.String listener;

        /**
         * Sets the value of {@link NetworkTargetProps#getContainerPort}
         * @param containerPort The port number of the container. This parameter is required.
         *                      Only applicable when using application/network load balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(java.lang.Number containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        /**
         * Sets the value of {@link NetworkTargetProps#getListener}
         * @param listener Name of the listener the target group attached to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(java.lang.String listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkTargetProps build() {
            return new Jsii$Proxy(containerPort, listener);
        }
    }

    /**
     * An implementation for {@link NetworkTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkTargetProps {
        private final java.lang.Number containerPort;
        private final java.lang.String listener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number containerPort, final java.lang.String listener) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPort = java.util.Objects.requireNonNull(containerPort, "containerPort is required");
            this.listener = listener;
        }

        @Override
        public final java.lang.Number getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final java.lang.String getListener() {
            return this.listener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPort", om.valueToTree(this.getContainerPort()));
            if (this.getListener() != null) {
                data.set("listener", om.valueToTree(this.getListener()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.NetworkTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkTargetProps.Jsii$Proxy that = (NetworkTargetProps.Jsii$Proxy) o;

            if (!containerPort.equals(that.containerPort)) return false;
            return this.listener != null ? this.listener.equals(that.listener) : that.listener == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerPort.hashCode();
            result = 31 * result + (this.listener != null ? this.listener.hashCode() : 0);
            return result;
        }
    }
}
