package software.amazon.awscdk.services.ecs.patterns;

/**
 * Class to create a queue processing EC2 service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:26.528Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.QueueProcessingEc2Service")
public class QueueProcessingEc2Service extends software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBase {

    protected QueueProcessingEc2Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingEc2Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the QueueProcessingEc2Service class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueueProcessingEc2Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The EC2 service in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2Service getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ec2Service.class));
    }

    /**
     * The EC2 task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ec2TaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2ServiceProps.Builder();
        }

        /**
         * The image used to start a container.
         * <p>
         * @return {@code this}
         * @param image The image used to start a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props.image(image);
            return this;
        }

        /**
         * Whether to enable the deployment circuit breaker.
         * <p>
         * If this property is defined, circuit breaker will be implicitly
         * enabled.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param circuitBreaker Whether to enable the deployment circuit breaker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The command that is passed to the container.
         * <p>
         * If you provide a shell command as a single string, you have to quote command-line arguments.
         * <p>
         * Default: - CMD value built into container image.
         * <p>
         * @return {@code this}
         * @param command The command that is passed to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * Specifies which deployment controller to use for the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * <p>
         * Default: - Rolling update (ECS)
         * <p>
         * @return {@code this}
         * @param deploymentController Specifies which deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        /**
         * (deprecated) The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: - If the feature flag, ECS_REMOVE_DEFAULT_DESIRED_COUNT is false, the default is 1;
         * if true, the minScalingCapacity is 1 for all new services and uses the existing services desired count
         * when updating an existing service.
         * <p>
         * @return {@code this}
         * @deprecated - Use `minScalingCapacity` or a literal object instead.
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder desiredTaskCount(final java.lang.Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Flag to indicate whether to enable logging.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableLogging Flag to indicate whether to enable logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(final java.lang.Boolean enableLogging) {
            this.props.enableLogging(enableLogging);
            return this;
        }

        /**
         * The environment variables to pass to the container.
         * <p>
         * The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
         * always be passed.
         * <p>
         * Default: 'QUEUE_NAME: queue.queueName'
         * <p>
         * @return {@code this}
         * @param environment The environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The name of a family that the task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that the task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props.family(family);
            return this;
        }

        /**
         * The log driver to use.
         * <p>
         * Default: - AwsLogDriver if enableLogging is true
         * <p>
         * @return {@code this}
         * @param logDriver The log driver to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(final software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.props.logDriver(logDriver);
            return this;
        }

        /**
         * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - default from underlying service.
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * The maximum number of times that a message can be received by consumers.
         * <p>
         * When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param maxReceiveCount The maximum number of times that a message can be received by consumers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceiveCount(final java.lang.Number maxReceiveCount) {
            this.props.maxReceiveCount(maxReceiveCount);
            return this;
        }

        /**
         * Maximum capacity to scale to.
         * <p>
         * Default: - If the feature flag, ECS_REMOVE_DEFAULT_DESIRED_COUNT is false, the default is (desiredTaskCount * 2); if true, the default is 2.
         * <p>
         * @return {@code this}
         * @param maxScalingCapacity Maximum capacity to scale to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxScalingCapacity(final java.lang.Number maxScalingCapacity) {
            this.props.maxScalingCapacity(maxScalingCapacity);
            return this;
        }

        /**
         * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - default from underlying service.
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * Minimum capacity to scale to.
         * <p>
         * Default: - If the feature flag, ECS_REMOVE_DEFAULT_DESIRED_COUNT is false, the default is the desiredTaskCount; if true, the default is 1.
         * <p>
         * @return {@code this}
         * @param minScalingCapacity Minimum capacity to scale to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minScalingCapacity(final java.lang.Number minScalingCapacity) {
            this.props.minScalingCapacity(minScalingCapacity);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * A queue for which to process items from.
         * <p>
         * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
         * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
         * <p>
         * Default: 'SQSQueue with CloudFormation-generated name'
         * <p>
         * @return {@code this}
         * @param queue A queue for which to process items from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.props.queue(queue);
            return this;
        }

        /**
         * The number of seconds that Dead Letter Queue retains a message.
         * <p>
         * Default: Duration.days(14)
         * <p>
         * @return {@code this}
         * @param retentionPeriod The number of seconds that Dead Letter Queue retains a message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.core.Duration retentionPeriod) {
            this.props.retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         * <p>
         * Maps a range of metric values to a particular scaling behavior. See
         * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
         * <p>
         * Default: [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
         * <p>
         * @return {@code this}
         * @param scalingSteps The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(final java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.props.scalingSteps(scalingSteps);
            return this;
        }

        /**
         * The secret to expose to the container as an environment variable.
         * <p>
         * Default: - No secret environment variables.
         * <p>
         * @return {@code this}
         * @param secrets The secret to expose to the container as an environment variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Optional name for the container added.
         * <p>
         * Default: - QueueProcessingContainer
         * <p>
         * @return {@code this}
         * @param containerName Optional name for the container added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The hard limit (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory limit.
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The hard limit (in MiB) of memory to present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * When system memory is under contention, Docker attempts to keep the
         * container memory within the limit. If the container requires more memory,
         * it can consume up to the value specified by the Memory property or all of
         * the available memory on the container instance—whichever comes first.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory reserved.
         * <p>
         * @return {@code this}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(final java.lang.Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2Service build() {
            return new software.amazon.awscdk.services.ecs.patterns.QueueProcessingEc2Service(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
