/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.$Module;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs-patterns.ApplicationMultipleTargetGroupsEc2ServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ApplicationMultipleTargetGroupsEc2ServiceProps
extends JsiiSerializable,
ApplicationMultipleTargetGroupsServiceBaseProps {
    @Nullable
    default public Number getCpu() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public Number getMemoryReservationMiB() {
        return null;
    }

    @Nullable
    default public Ec2TaskDefinition getTaskDefinition() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationMultipleTargetGroupsEc2ServiceProps> {
        private Number cpu;
        private Number memoryLimitMiB;
        private Number memoryReservationMiB;
        private Ec2TaskDefinition taskDefinition;
        private CloudMapOptions cloudMapOptions;
        private ICluster cluster;
        private Number desiredCount;
        private Boolean enableEcsManagedTags;
        private Duration healthCheckGracePeriod;
        private List<ApplicationLoadBalancerProps> loadBalancers;
        private PropagatedTagSource propagateTags;
        private String serviceName;
        private List<ApplicationTargetProps> targetGroups;
        private ApplicationLoadBalancedTaskImageProps taskImageOptions;
        private IVpc vpc;

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder loadBalancers(List<? extends ApplicationLoadBalancerProps> loadBalancers) {
            this.loadBalancers = loadBalancers;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder targetGroups(List<? extends ApplicationTargetProps> targetGroups) {
            this.targetGroups = targetGroups;
            return this;
        }

        public Builder taskImageOptions(ApplicationLoadBalancedTaskImageProps taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ApplicationMultipleTargetGroupsEc2ServiceProps build() {
            return new Jsii.Proxy(this.cpu, this.memoryLimitMiB, this.memoryReservationMiB, this.taskDefinition, this.cloudMapOptions, this.cluster, this.desiredCount, this.enableEcsManagedTags, this.healthCheckGracePeriod, this.loadBalancers, this.propagateTags, this.serviceName, this.targetGroups, this.taskImageOptions, this.vpc);
        }
    }
}

