package software.amazon.awscdk.services.ecs;

/**
 * A regional grouping of one or more container instances on which you can run tasks and services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:41.770Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.Cluster")
public class Cluster extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ecs.ICluster {

    protected Cluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the Cluster class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Cluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the Cluster class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Cluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing cluster to the stack from its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster fromClusterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ClusterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Cluster.class, "fromClusterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * This method adds compute capacity to a cluster using the specified AutoScalingGroup.
     * <p>
     * @param autoScalingGroup the ASG to add to this cluster. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAutoScalingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions options) {
        software.amazon.jsii.Kernel.call(this, "addAutoScalingGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), options });
    }

    /**
     * This method adds compute capacity to a cluster using the specified AutoScalingGroup.
     * <p>
     * @param autoScalingGroup the ASG to add to this cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAutoScalingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup) {
        software.amazon.jsii.Kernel.call(this, "addAutoScalingGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required") });
    }

    /**
     * This method adds compute capacity to a cluster by creating an AutoScalingGroup with the specified options.
     * <p>
     * Returns the AutoScalingGroup so you can add autoscaling settings to it.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup addCapacity(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AddCapacityOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * addCapacityProvider adds the name of a capacityProvider to the list of supproted capacityProviders for a cluster.
     * <p>
     * @param provider the capacity provider to add to this cluster. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addCapacityProvider(final @org.jetbrains.annotations.NotNull java.lang.String provider) {
        software.amazon.jsii.Kernel.call(this, "addCapacityProvider", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(provider, "provider is required") });
    }

    /**
     * Add an AWS Cloud Map DNS namespace for this cluster.
     * <p>
     * NOTE: HttpNamespaces are not supported, as ECS always requires a DNSConfig when registering an instance to a Cloud
     * Map service.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.INamespace addDefaultCloudMapNamespace(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addDefaultCloudMapNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.INamespace.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * This method returns the specifed CloudWatch metric for this cluster.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * This method returns the specifed CloudWatch metric for this cluster.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU reservation.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuReservation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCpuReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU reservation.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuReservation() {
        return software.amazon.jsii.Kernel.call(this, "metricCpuReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters CPU utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory reservation.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryReservation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory reservation.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryReservation() {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryReservation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * This method returns the CloudWatch metric for this clusters memory utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The Amazon Resource Name (ARN) that identifies the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Manage the allowed network connections for the cluster with Security Groups.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Whether the cluster has EC2 capacity associated with it.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getHasEc2Capacity() {
        return software.amazon.jsii.Kernel.get(this, "hasEc2Capacity", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The VPC associated with the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * Getter for autoscaling group added to cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoscalingGroup() {
        return software.amazon.jsii.Kernel.get(this, "autoscalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
    }

    /**
     * Getter for namespace added to cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.INamespace getDefaultCloudMapNamespace() {
        return software.amazon.jsii.Kernel.get(this, "defaultCloudMapNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.INamespace.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.Cluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.Cluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.ClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The ec2 capacity to add to the cluster.
         * <p>
         * Default: - no EC2 capacity will be added, you can use `addCapacity` to add capacity later.
         * <p>
         * @return {@code this}
         * @param capacity The ec2 capacity to add to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(final software.amazon.awscdk.services.ecs.AddCapacityOptions capacity) {
            this.props().capacity(capacity);
            return this;
        }

        /**
         * The capacity providers to add to the cluster.
         * <p>
         * Default: - None. Currently only FARGATE and FARGATE_SPOT are supported.
         * <p>
         * @return {@code this}
         * @param capacityProviders The capacity providers to add to the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviders(final java.util.List<java.lang.String> capacityProviders) {
            this.props().capacityProviders(capacityProviders);
            return this;
        }

        /**
         * The name for the cluster.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param clusterName The name for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * If true CloudWatch Container Insights will be enabled for the cluster.
         * <p>
         * Default: - Container Insights will be disabled for this cluser.
         * <p>
         * @return {@code this}
         * @param containerInsights If true CloudWatch Container Insights will be enabled for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerInsights(final java.lang.Boolean containerInsights) {
            this.props().containerInsights(containerInsights);
            return this;
        }

        /**
         * The service discovery namespace created in this cluster.
         * <p>
         * Default: - no service discovery namespace created, you can use `addDefaultCloudMapNamespace` to add a
         * default service discovery namespace later.
         * <p>
         * @return {@code this}
         * @param defaultCloudMapNamespace The service discovery namespace created in this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCloudMapNamespace(final software.amazon.awscdk.services.ecs.CloudMapNamespaceOptions defaultCloudMapNamespace) {
            this.props().defaultCloudMapNamespace(defaultCloudMapNamespace);
            return this;
        }

        /**
         * The VPC where your ECS instances will be running or your ENIs will be deployed.
         * <p>
         * Default: - creates a new VPC with two AZs
         * <p>
         * @return {@code this}
         * @param vpc The VPC where your ECS instances will be running or your ENIs will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.Cluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.Cluster build() {
            return new software.amazon.awscdk.services.ecs.Cluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.ClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.ClusterProps.Builder();
            }
            return this.props;
        }
    }
}
