package software.amazon.awscdk.services.ecs;

/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:41.800Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.EcsOptimizedImage")
public class EcsOptimizedImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected EcsOptimizedImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsOptimizedImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class));
    }

    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param hardwareType ECS-optimized AMI variant to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AmiHardwareType hardwareType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { hardwareType });
    }

    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class));
    }

    /**
     * Construct a Windows image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param windowsVersion Windows Version to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage windows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.WindowsOptimizedVersion windowsVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "windows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { java.util.Objects.requireNonNull(windowsVersion, "windowsVersion is required") });
    }

    /**
     * Return the correct image.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }
}
