package software.amazon.awscdk.services.ecs;

/**
 * A reference to an existing task definition.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:41.849Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.$Module.class, fqn = "@aws-cdk/aws-ecs.TaskDefinitionAttributes")
@software.amazon.jsii.Jsii.Proxy(TaskDefinitionAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TaskDefinitionAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.CommonTaskDefinitionAttributes {

    /**
     * What launch types this task definition should be compatible with.
     * <p>
     * Default: Compatibility.EC2_AND_FARGATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TaskDefinitionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TaskDefinitionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TaskDefinitionAttributes> {
        private software.amazon.awscdk.services.ecs.Compatibility compatibility;
        private java.lang.String taskDefinitionArn;
        private software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private software.amazon.awscdk.services.iam.IRole taskRole;

        /**
         * Sets the value of {@link TaskDefinitionAttributes#getCompatibility}
         * @param compatibility What launch types this task definition should be compatible with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(software.amazon.awscdk.services.ecs.Compatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionAttributes#getTaskDefinitionArn}
         * @param taskDefinitionArn The arn of the task definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionArn(java.lang.String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionAttributes#getNetworkMode}
         * @param networkMode The networking mode to use for the containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionAttributes#getTaskRole}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskDefinitionAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TaskDefinitionAttributes build() {
            return new Jsii$Proxy(compatibility, taskDefinitionArn, networkMode, taskRole);
        }
    }

    /**
     * An implementation for {@link TaskDefinitionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskDefinitionAttributes {
        private final software.amazon.awscdk.services.ecs.Compatibility compatibility;
        private final java.lang.String taskDefinitionArn;
        private final software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private final software.amazon.awscdk.services.iam.IRole taskRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compatibility = software.amazon.jsii.Kernel.get(this, "compatibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Compatibility.class));
            this.taskDefinitionArn = software.amazon.jsii.Kernel.get(this, "taskDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
            this.taskRole = software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.ecs.Compatibility compatibility, final java.lang.String taskDefinitionArn, final software.amazon.awscdk.services.ecs.NetworkMode networkMode, final software.amazon.awscdk.services.iam.IRole taskRole) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compatibility = compatibility;
            this.taskDefinitionArn = java.util.Objects.requireNonNull(taskDefinitionArn, "taskDefinitionArn is required");
            this.networkMode = networkMode;
            this.taskRole = taskRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final java.lang.String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCompatibility() != null) {
                data.set("compatibility", om.valueToTree(this.getCompatibility()));
            }
            data.set("taskDefinitionArn", om.valueToTree(this.getTaskDefinitionArn()));
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs.TaskDefinitionAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TaskDefinitionAttributes.Jsii$Proxy that = (TaskDefinitionAttributes.Jsii$Proxy) o;

            if (this.compatibility != null ? !this.compatibility.equals(that.compatibility) : that.compatibility != null) return false;
            if (!taskDefinitionArn.equals(that.taskDefinitionArn)) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            return this.taskRole != null ? this.taskRole.equals(that.taskRole) : that.taskRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compatibility != null ? this.compatibility.hashCode() : 0;
            result = 31 * result + (this.taskDefinitionArn.hashCode());
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            return result;
        }
    }
}
