package software.amazon.awscdk.services.efs;

/**
 * EFS Lifecycle Policy, if a file is not accessed for given days, it will move to EFS Infrequent Access.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-elasticfilesystem-filesystem-lifecyclepolicies
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:08.141Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.LifecyclePolicy")
public enum LifecyclePolicy {
    /**
     * After 7 days of not being accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_7_DAYS,
    /**
     * After 14 days of not being accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_14_DAYS,
    /**
     * After 30 days of not being accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_30_DAYS,
    /**
     * After 60 days of not being accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_60_DAYS,
    /**
     * After 90 days of not being accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_90_DAYS,
}
