package software.amazon.awscdk.services.efs;

/**
 * EFS Performance mode.
 * <p>
 * @see https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:40:08.141Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.efs.$Module.class, fqn = "@aws-cdk/aws-efs.PerformanceMode")
public enum PerformanceMode {
    /**
     * General Purpose is ideal for latency-sensitive use cases, like web serving environments, content management systems, home directories, and general file serving.
     * <p>
     * Recommended for the majority of Amazon EFS file systems.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GENERAL_PURPOSE,
    /**
     * File systems in the Max I/O mode can scale to higher levels of aggregate throughput and operations per second.
     * <p>
     * This scaling is done with a tradeoff
     * of slightly higher latencies for file metadata operations.
     * Highly parallelized applications and workloads, such as big data analysis,
     * media processing, and genomics analysis, can benefit from this mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAX_IO,
}
