package software.amazon.awscdk.services.kms;

/**
 * The key spec, represents the cryptographic configuration of keys.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-14T22:39:42.559Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kms.$Module.class, fqn = "@aws-cdk/aws-kms.KeySpec")
public enum KeySpec {
    /**
     * The default key spec.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYMMETRIC_DEFAULT,
    /**
     * RSA with 2048 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_2048,
    /**
     * RSA with 3072 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_3072,
    /**
     * RSA with 4096 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_4096,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-256 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P256,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-384 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P384,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-512 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P521,
    /**
     * Standards for Efficient Cryptography 2, Section 2.4.1, ECDSA signature on the Koblitz curve.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_SECG_P256K1,
}
