package software.amazon.awscdk.services.rds;

/**
 * A database secret.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-20T16:34:21.761Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.rds.$Module.class, fqn = "@aws-cdk/aws-rds.DatabaseSecret")
public class DatabaseSecret extends software.amazon.awscdk.services.secretsmanager.Secret {

    protected DatabaseSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseSecretProps.Builder();
        }

        /**
         * The username.
         * <p>
         * @return {@code this}
         * @param username The username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * The KMS key to use to encrypt the secret.
         * <p>
         * Default: default master key
         * <p>
         * @return {@code this}
         * @param encryptionKey The KMS key to use to encrypt the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Characters to not include in the generated password.
         * <p>
         * Default: " %+~`#$&*()|[]{}:;<>?!'/
         * <p>
         * @return {@code this}
         * @param excludeCharacters Characters to not include in the generated password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(final java.lang.String excludeCharacters) {
            this.props.excludeCharacters(excludeCharacters);
            return this;
        }

        /**
         * The master secret which will be used to rotate this secret.
         * <p>
         * Default: - no master secret information will be included
         * <p>
         * @return {@code this}
         * @param masterSecret The master secret which will be used to rotate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterSecret(final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.props.masterSecret(masterSecret);
            return this;
        }

        /**
         * Whether to replace this secret when the criteria for the password change.
         * <p>
         * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
         * with a hash of the options that influence the password generation. This
         * way a new secret will be created when the password is regenerated and the
         * cluster or instance consuming this secret will have its credentials updated.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param replaceOnPasswordCriteriaChanges Whether to replace this secret when the criteria for the password change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceOnPasswordCriteriaChanges(final java.lang.Boolean replaceOnPasswordCriteriaChanges) {
            this.props.replaceOnPasswordCriteriaChanges(replaceOnPasswordCriteriaChanges);
            return this;
        }

        /**
         * A name for the secret.
         * <p>
         * Default: - A name is generated by CloudFormation.
         * <p>
         * @return {@code this}
         * @param secretName A name for the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(final java.lang.String secretName) {
            this.props.secretName(secretName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseSecret build() {
            return new software.amazon.awscdk.services.rds.DatabaseSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
