package software.amazon.awscdk.services.servicediscovery;

/**
 * Service props needed to create a service in a given namespace.
 * <p>
 * Used by createService() for PrivateDnsNamespace and
 * PublicDnsNamespace
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.28.0 (build 1801f4f)", date = "2021-04-28T11:08:05.589Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicediscovery.$Module.class, fqn = "@aws-cdk/aws-servicediscovery.DnsServiceProps")
@software.amazon.jsii.Jsii.Proxy(DnsServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DnsServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.servicediscovery.BaseServiceProps {

    /**
     * The DNS type of the record that you want AWS Cloud Map to create.
     * <p>
     * Supported record types
     * include A, AAAA, A and AAAA (A_AAAA), CNAME, and SRV.
     * <p>
     * Default: A
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType() {
        return null;
    }

    /**
     * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
     * <p>
     * Default: Duration.minutes(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDnsTtl() {
        return null;
    }

    /**
     * Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance.
     * <p>
     * Setting this to <code>true</code> correctly configures the <code>routingPolicy</code>
     * and performs some additional validation.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLoadBalancer() {
        return null;
    }

    /**
     * The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service.
     * <p>
     * Default: WEIGHTED for CNAME records and when loadBalancer is true, MULTIVALUE otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DnsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DnsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DnsServiceProps> {
        private software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        private software.amazon.awscdk.core.Duration dnsTtl;
        private java.lang.Boolean loadBalancer;
        private software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        private software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private java.lang.String description;
        private software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private java.lang.String name;

        /**
         * Sets the value of {@link DnsServiceProps#getDnsRecordType}
         * @param dnsRecordType The DNS type of the record that you want AWS Cloud Map to create.
         *                      Supported record types
         *                      include A, AAAA, A and AAAA (A_AAAA), CNAME, and SRV.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsRecordType(software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType) {
            this.dnsRecordType = dnsRecordType;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getDnsTtl}
         * @param dnsTtl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsTtl(software.amazon.awscdk.core.Duration dnsTtl) {
            this.dnsTtl = dnsTtl;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getLoadBalancer}
         * @param loadBalancer Whether or not this service will have an Elastic LoadBalancer registered to it as an AliasTargetInstance.
         *                     Setting this to <code>true</code> correctly configures the <code>routingPolicy</code>
         *                     and performs some additional validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(java.lang.Boolean loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getRoutingPolicy}
         * @param routingPolicy The routing policy that you want to apply to all DNS records that AWS Cloud Map creates when you register an instance and specify this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingPolicy(software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy) {
            this.routingPolicy = routingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getCustomHealthCheck}
         * @param customHealthCheck Structure containing failure threshold for a custom health checker.
         *                          Only one of healthCheckConfig or healthCheckCustomConfig can be specified.
         *                          See: https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHealthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck) {
            this.customHealthCheck = customHealthCheck;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getDescription}
         * @param description A description of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getHealthCheck}
         * @param healthCheck Settings for an optional health check.
         *                    If you specify health check settings, AWS Cloud Map associates the health
         *                    check with the records that you specify in DnsConfig. Only one of healthCheckConfig or healthCheckCustomConfig can
         *                    be specified. Not valid for PrivateDnsNamespaces. If you use healthCheck, you can only register IP instances to
         *                    this service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link DnsServiceProps#getName}
         * @param name A name for the Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DnsServiceProps build() {
            return new Jsii$Proxy(dnsRecordType, dnsTtl, loadBalancer, routingPolicy, customHealthCheck, description, healthCheck, name);
        }
    }

    /**
     * An implementation for {@link DnsServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsServiceProps {
        private final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType;
        private final software.amazon.awscdk.core.Duration dnsTtl;
        private final java.lang.Boolean loadBalancer;
        private final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsRecordType = software.amazon.jsii.Kernel.get(this, "dnsRecordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.DnsRecordType.class));
            this.dnsTtl = software.amazon.jsii.Kernel.get(this, "dnsTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.loadBalancer = software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.routingPolicy = software.amazon.jsii.Kernel.get(this, "routingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.RoutingPolicy.class));
            this.customHealthCheck = software.amazon.jsii.Kernel.get(this, "customHealthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.HealthCheckConfig.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.servicediscovery.DnsRecordType dnsRecordType, final software.amazon.awscdk.core.Duration dnsTtl, final java.lang.Boolean loadBalancer, final software.amazon.awscdk.services.servicediscovery.RoutingPolicy routingPolicy, final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig customHealthCheck, final java.lang.String description, final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig healthCheck, final java.lang.String name) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsRecordType = dnsRecordType;
            this.dnsTtl = dnsTtl;
            this.loadBalancer = loadBalancer;
            this.routingPolicy = routingPolicy;
            this.customHealthCheck = customHealthCheck;
            this.description = description;
            this.healthCheck = healthCheck;
            this.name = name;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.DnsRecordType getDnsRecordType() {
            return this.dnsRecordType;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getDnsTtl() {
            return this.dnsTtl;
        }

        @Override
        public final java.lang.Boolean getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.RoutingPolicy getRoutingPolicy() {
            return this.routingPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.HealthCheckCustomConfig getCustomHealthCheck() {
            return this.customHealthCheck;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.HealthCheckConfig getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDnsRecordType() != null) {
                data.set("dnsRecordType", om.valueToTree(this.getDnsRecordType()));
            }
            if (this.getDnsTtl() != null) {
                data.set("dnsTtl", om.valueToTree(this.getDnsTtl()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getRoutingPolicy() != null) {
                data.set("routingPolicy", om.valueToTree(this.getRoutingPolicy()));
            }
            if (this.getCustomHealthCheck() != null) {
                data.set("customHealthCheck", om.valueToTree(this.getCustomHealthCheck()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicediscovery.DnsServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DnsServiceProps.Jsii$Proxy that = (DnsServiceProps.Jsii$Proxy) o;

            if (this.dnsRecordType != null ? !this.dnsRecordType.equals(that.dnsRecordType) : that.dnsRecordType != null) return false;
            if (this.dnsTtl != null ? !this.dnsTtl.equals(that.dnsTtl) : that.dnsTtl != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.routingPolicy != null ? !this.routingPolicy.equals(that.routingPolicy) : that.routingPolicy != null) return false;
            if (this.customHealthCheck != null ? !this.customHealthCheck.equals(that.customHealthCheck) : that.customHealthCheck != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dnsRecordType != null ? this.dnsRecordType.hashCode() : 0;
            result = 31 * result + (this.dnsTtl != null ? this.dnsTtl.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.routingPolicy != null ? this.routingPolicy.hashCode() : 0);
            result = 31 * result + (this.customHealthCheck != null ? this.customHealthCheck.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
