/**
 * <h1>Amazon ECS Service Discovery Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * This package contains constructs for working with <strong>AWS Cloud Map</strong>
 * <p>
 * AWS Cloud Map is a fully managed service that you can use to create and
 * maintain a map of the backend services and resources that your applications
 * depend on.
 * <p>
 * For further information on AWS Cloud Map,
 * see the <a href="https://docs.aws.amazon.com/cloud-map">AWS Cloud Map documentation</a>
 * <p>
 * <h2>HTTP Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports API calls, creates a service in that namespace, and
 * registers an instance to it:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * import lib.*;
 * 
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * 
 * HttpNamespace namespace = new HttpNamespace(stack, "MyNamespace", new HttpNamespaceProps()
 *         .name("covfefe"));
 * 
 * Service service1 = namespace.createService("NonIpService", new BaseServiceProps()
 *         .description("service registering non-ip instances"));
 * 
 * service1.registerNonIpInstance("NonIpInstance", new NonIpInstanceBaseProps()
 *         .customAttributes(Map.of("arn", "arn:aws:s3:::mybucket")));
 * 
 * Service service2 = namespace.createService("IpService", new BaseServiceProps()
 *         .description("service registering ip instances")
 *         .healthCheck(new HealthCheckConfig()
 *                 .type(servicediscovery.HealthCheckType.getHTTP())
 *                 .resourcePath("/check")));
 * 
 * service2.registerIpInstance("IpInstance", Map.of(
 *         "ipv4", "54.239.25.192"));
 * 
 * app.synth();
 * </pre></blockquote>
 * <p>
 * <h2>Private DNS Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports both API calls and DNS queries within a vpc, creates a
 * service in that namespace, and registers a loadbalancer as an
 * instance:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.core.*;
 * import lib.*;
 * 
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * 
 * Vpc vpc = new Vpc(stack, "Vpc", new VpcProps().maxAzs(2));
 * 
 * PrivateDnsNamespace namespace = new PrivateDnsNamespace(stack, "Namespace", new PrivateDnsNamespaceProps()
 *         .name("boobar.com")
 *         .vpc(vpc));
 * 
 * Service service = namespace.createService("Service", new DnsServiceProps()
 *         .dnsRecordType(servicediscovery.DnsRecordType.getA_AAAA())
 *         .dnsTtl(cdk.Duration.seconds(30))
 *         .loadBalancer(true));
 * 
 * ApplicationLoadBalancer loadbalancer = new ApplicationLoadBalancer(stack, "LB", new ApplicationLoadBalancerProps().vpc(vpc).internetFacing(true));
 * 
 * service.registerLoadBalancer("Loadbalancer", loadbalancer);
 * 
 * app.synth();
 * </pre></blockquote>
 * <p>
 * <h2>Public DNS Namespace Example</h2>
 * <p>
 * The following example creates an AWS Cloud Map namespace that
 * supports both API calls and public DNS queries, creates a service in
 * that namespace, and registers an IP instance:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * import lib.*;
 * 
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * 
 * PublicDnsNamespace namespace = new PublicDnsNamespace(stack, "Namespace", new PublicDnsNamespaceProps()
 *         .name("foobar.com"));
 * 
 * Service service = namespace.createService("Service", new DnsServiceProps()
 *         .name("foo")
 *         .dnsRecordType(servicediscovery.DnsRecordType.getA())
 *         .dnsTtl(cdk.Duration.seconds(30))
 *         .healthCheck(new HealthCheckConfig()
 *                 .type(servicediscovery.HealthCheckType.getHTTPS())
 *                 .resourcePath("/healthcheck")
 *                 .failureThreshold(2)));
 * 
 * service.registerIpInstance("IpInstance", Map.of(
 *         "ipv4", "54.239.25.192",
 *         "port", 443));
 * 
 * app.synth();
 * </pre></blockquote>
 * <p>
 * For DNS namespaces, you can also register instances to services with CNAME records:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * import lib.*;
 * 
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * 
 * PublicDnsNamespace namespace = new PublicDnsNamespace(stack, "Namespace", new PublicDnsNamespaceProps()
 *         .name("foobar.com"));
 * 
 * Service service = namespace.createService("Service", new DnsServiceProps()
 *         .name("foo")
 *         .dnsRecordType(servicediscovery.DnsRecordType.getCNAME())
 *         .dnsTtl(cdk.Duration.seconds(30)));
 * 
 * service.registerCnameInstance("CnameInstance", new CnameInstanceBaseProps()
 *         .instanceCname("service.pizza"));
 * 
 * app.synth();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.servicediscovery;
