/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermList;
import aterm.Visitor;
import aterm.pure.ATermImpl;
import aterm.pure.PureFactory;
import jjtraveler.VisitFailure;
import shared.SharedObject;

class AFunImpl
extends ATermImpl
implements AFun {
    String name;
    int arity;
    boolean isQuoted;

    protected AFunImpl(PureFactory factory) {
        super(factory);
    }

    protected void init(int hashCode, String name, int arity, boolean isQuoted) {
        super.init(hashCode, null);
        this.name = name.intern();
        this.arity = arity;
        this.isQuoted = isQuoted;
    }

    protected void initHashCode(String name, int arity, boolean isQuoted) {
        this.name = name.intern();
        this.arity = arity;
        this.isQuoted = isQuoted;
        this.setHashCode(this.hashFunction());
    }

    public SharedObject duplicate() {
        AFunImpl clone = new AFunImpl(this.factory);
        clone.init(this.hashCode(), this.name, this.arity, this.isQuoted);
        return clone;
    }

    public boolean equivalent(SharedObject obj) {
        try {
            AFun peer = (AFun)((Object)obj);
            return peer.getName() == this.name && peer.getArity() == this.arity && peer.isQuoted() == this.isQuoted;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int getType() {
        return 7;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public ATerm getAnnotation(ATerm key) {
        throw new UnsupportedOperationException();
    }

    public ATermList getAnnotations() {
        throw new UnsupportedOperationException();
    }

    public ATerm setAnnotations(ATermList annos) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name.length());
        if (this.isQuoted) {
            result.append('\"');
        }
        int i = 0;
        while (i < this.name.length()) {
            char c = this.name.charAt(i);
            switch (c) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    break;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    break;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    break;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    break;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    break;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    break;
                }
                case '\'': {
                    result.append('\\');
                    result.append('\'');
                    break;
                }
                case '\"': {
                    result.append('\\');
                    result.append('\"');
                    break;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    result.append(c);
                    break;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        result.append(c);
                        break;
                    }
                    result.append('\\');
                    result.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    result.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    result.append((char)(48 + c));
                }
            }
            ++i;
        }
        if (this.isQuoted) {
            result.append('\"');
        }
        return result.toString();
    }

    public void accept(Visitor v) throws VisitFailure {
        v.visitAFun(this);
    }

    private int hashFunction() {
        int b = -1640531527;
        int a = -1640531527;
        int len = this.name.length();
        if (len >= 12) {
            return this.hashFunction2();
        }
        int c = this.isQuoted ? 7 * this.arity + 1 : this.arity + 1;
        c += len;
        switch (len) {
            case 11: {
                c += this.name.charAt(10) << 24;
            }
            case 10: {
                c += this.name.charAt(9) << 16;
            }
            case 9: {
                c += this.name.charAt(8) << 8;
            }
            case 8: {
                b += this.name.charAt(7) << 24;
            }
            case 7: {
                b += this.name.charAt(6) << 16;
            }
            case 6: {
                b += this.name.charAt(5) << 8;
            }
            case 5: {
                b += this.name.charAt(4);
            }
            case 4: {
                a += this.name.charAt(3) << 24;
            }
            case 3: {
                a += this.name.charAt(2) << 16;
            }
            case 2: {
                a += this.name.charAt(1) << 8;
            }
            case 1: {
                a += this.name.charAt(0);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }

    private int hashFunction2() {
        int offset = 0;
        int count = this.name.length();
        char[] source = new char[count];
        offset = 0;
        this.name.getChars(0, count, source, 0);
        int len = count;
        int b = -1640531527;
        int a = -1640531527;
        int c = this.isQuoted ? 7 * (this.arity + 1) : this.arity + 1;
        int k = offset;
        while (len >= 12) {
            a += source[k + 0] + (source[k + 1] << 8) + (source[k + 2] << 16) + (source[k + 3] << 24);
            a -= (b += source[k + 4] + (source[k + 5] << 8) + (source[k + 6] << 16) + (source[k + 7] << 24));
            a -= (c += source[k + 8] + (source[k + 9] << 8) + (source[k + 10] << 16) + (source[k + 11] << 24));
            b -= c;
            b -= (a ^= c >> 13);
            c -= a;
            c -= (b ^= a << 8);
            a -= b;
            a -= (c ^= b >> 13);
            b -= c;
            b -= (a ^= c >> 12);
            c -= a;
            c -= (b ^= a << 16);
            a -= b;
            a -= (c ^= b >> 5);
            b -= c;
            b -= (a ^= c >> 3);
            c -= a;
            c -= (b ^= a << 10);
            c ^= b >> 15;
            k += 12;
            len -= 12;
        }
        c += count;
        switch (len) {
            case 11: {
                c += source[k + 10] << 24;
            }
            case 10: {
                c += source[k + 9] << 16;
            }
            case 9: {
                c += source[k + 8] << 8;
            }
            case 8: {
                b += source[k + 7] << 24;
            }
            case 7: {
                b += source[k + 6] << 16;
            }
            case 6: {
                b += source[k + 5] << 8;
            }
            case 5: {
                b += source[k + 4];
            }
            case 4: {
                a += source[k + 3] << 24;
            }
            case 3: {
                a += source[k + 2] << 16;
            }
            case 2: {
                a += source[k + 1] << 8;
            }
            case 1: {
                a += source[k + 0];
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

