/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PackedOffsets
implements Loggable {
    private short[] data;
    private int size;
    static final /* synthetic */ boolean $assertionsDisabled;

    Iterator iterator() {
        return new Iterator();
    }

    public void pack(long[] offsets) {
        short[] newData = new short[offsets.length * 3];
        Arrays.sort(offsets);
        int dataIndex = 0;
        long priorVal = 0L;
        for (int i = 0; i < offsets.length; ++i) {
            long val = offsets[i];
            dataIndex = this.append(newData, dataIndex, val - priorVal);
            priorVal = val;
        }
        this.data = new short[dataIndex];
        System.arraycopy(newData, 0, this.data, 0, dataIndex);
        this.size = offsets.length;
    }

    long[] toArray() {
        long[] offsets = new long[this.size];
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            offsets[index++] = iter.next();
        }
        if (!$assertionsDisabled && index != this.size) {
            throw new AssertionError();
        }
        return offsets;
    }

    private int append(short[] to, int index, long val) {
        short s;
        if (!$assertionsDisabled && val < 0L) {
            throw new AssertionError();
        }
        while (true) {
            s = (short)(val & 0x7FFFL);
            if ((val >>>= 15) <= 0L) break;
            to[index++] = (short)(-1 - s);
        }
        to[index++] = s;
        return index;
    }

    public int getExtraMemorySize() {
        if (this.data != null) {
            return MemoryBudget.shortArraySize(this.data.length);
        }
        return 0;
    }

    public int getLogSize() {
        return 2 * LogUtils.getIntLogSize() + (this.data != null ? this.data.length * 2 : 0);
    }

    public void writeToLog(ByteBuffer buf) {
        LogUtils.writeInt(buf, this.size);
        if (this.data != null) {
            LogUtils.writeInt(buf, this.data.length);
            for (int i = 0; i < this.data.length; ++i) {
                LogUtils.writeShort(buf, this.data[i]);
            }
        } else {
            LogUtils.writeInt(buf, 0);
        }
    }

    public void readFromLog(ByteBuffer buf, byte entryTypeVersion) {
        this.size = LogUtils.readInt(buf);
        int len = LogUtils.readInt(buf);
        if (len > 0) {
            this.data = new short[len];
            for (int i = 0; i < len; ++i) {
                this.data[i] = LogUtils.readShort(buf);
            }
        }
    }

    public void dumpLog(StringBuffer buf, boolean verbose) {
        if (this.size > 0) {
            Iterator i = this.iterator();
            buf.append("<offsets size=\"");
            buf.append(this.size);
            buf.append("\">");
            while (i.hasNext()) {
                buf.append("0x");
                buf.append(Long.toHexString(i.next()));
                buf.append(' ');
            }
            buf.append("</offsets>");
        } else {
            buf.append("<offsets size=\"0\"/>");
        }
    }

    public long getTransactionId() {
        return -1L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dumpLog(buf, true);
        return buf.toString();
    }

    static {
        $assertionsDisabled = !PackedOffsets.class.desiredAssertionStatus();
    }

    class Iterator {
        private int index;
        private long priorVal;

        private Iterator() {
        }

        boolean hasNext() {
            return PackedOffsets.this.data != null && this.index < PackedOffsets.this.data.length;
        }

        long next() {
            long s;
            long val = this.priorVal;
            int shift = 0;
            while (true) {
                if ((s = (long)PackedOffsets.this.data[this.index++]) >= 0L) break;
                val += -1L - s << shift;
                shift += 15;
            }
            this.priorVal = val += s << shift;
            return val;
        }
    }
}

