/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;
import java.nio.ByteBuffer;
import java.util.Comparator;

public final class DIN
extends IN {
    private static final String BEGIN_TAG = "<din>";
    private static final String END_TAG = "</din>";
    private byte[] dupKey;
    private ChildReference dupCountLNRef;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DIN() {
        this.dupCountLNRef = new ChildReference();
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public DIN(DatabaseImpl db, byte[] identifierKey, int capacity, byte[] dupKey, ChildReference dupCountLNRef, int level) {
        super(db, identifierKey, capacity, level);
        this.dupKey = dupKey;
        this.dupCountLNRef = dupCountLNRef;
        this.initMemorySize();
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new DIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, this.dupCountLNRef, level);
    }

    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    public byte[] getDupKey() {
        return this.dupKey;
    }

    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return dupTreeKey;
    }

    public byte[] getDupTreeKey() {
        return this.getIdentifierKey();
    }

    public byte[] getMainTreeKey() {
        return this.dupKey;
    }

    public ChildReference getDupCountLNRef() {
        return this.dupCountLNRef;
    }

    public DupCountLN getDupCountLN() throws DatabaseException {
        return (DupCountLN)this.dupCountLNRef.fetchTarget(this.getDatabase(), this);
    }

    void setDupCountLN(ChildReference dupCountLNRef) {
        this.updateMemorySize(this.dupCountLNRef, dupCountLNRef);
        this.dupCountLNRef = dupCountLNRef;
    }

    public void updateDupCountLN(Node target) {
        long oldSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.dupCountLNRef.setTarget(target);
        long newSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateDupCountLNRefAndNullTarget(long newLsn) {
        this.setDirty(true);
        long oldSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.dupCountLNRef.setTarget(null);
        if (this.notOverwritingDeferredWriteEntry(newLsn)) {
            this.dupCountLNRef.setLsn(newLsn);
        }
        long newSize = this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateDupCountLNRef(long newLsn) {
        this.setDirty(true);
        if (this.notOverwritingDeferredWriteEntry(newLsn)) {
            this.dupCountLNRef.setLsn(newLsn);
        }
    }

    public boolean containsDuplicates() {
        return true;
    }

    public boolean isDbRoot() {
        return false;
    }

    public final Comparator getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    public void incrementDuplicateCount(LockResult lockResult, byte[] key, Locker locker, boolean increment) throws DatabaseException {
        long oldLsn = this.dupCountLNRef.getLsn();
        lockResult.setAbortLsn(oldLsn, this.dupCountLNRef.isKnownDeleted());
        DupCountLN dupCountLN = this.getDupCountLN();
        if (increment) {
            dupCountLN.incDupCount();
        } else {
            dupCountLN.decDupCount();
            if (!$assertionsDisabled && dupCountLN.getDupCount() < 0) {
                throw new AssertionError();
            }
        }
        DatabaseImpl db = this.getDatabase();
        long newCountLSN = dupCountLN.optionalLogUpdateMemUsage(db, key, oldLsn, locker, this);
        this.updateDupCountLNRef(newCountLSN);
    }

    protected long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.dupCountLNRef != null) {
            size += this.getEntryInMemorySize(this.dupCountLNRef.getKey(), this.dupCountLNRef.getTarget());
        }
        return size;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.DIN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getDINOverhead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchLNByNodeId(TreeLocation location, long nodeId) throws DatabaseException {
        this.latch();
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                boolean ret;
                Node n = this.fetchTarget(i);
                if (n == null || !(ret = n.matchLNByNodeId(location, nodeId))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLatch();
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_DIN;
    }

    protected long logInternal(LogManager logManager, boolean allowDeltas, boolean isProvisional, boolean proactiveMigration, boolean backgroundIO, IN parent) throws DatabaseException {
        if (this.dupCountLNRef != null) {
            EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
            DupCountLN dupCntLN = (DupCountLN)this.dupCountLNRef.getTarget();
            if (dupCntLN != null && dupCntLN.isDirty()) {
                long newLsn = dupCntLN.logUpdateMemUsage(this.getDatabase(), this.dupKey, this.dupCountLNRef.getLsn(), null, this, backgroundIO);
                this.dupCountLNRef.setLsn(newLsn);
            } else {
                Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
                cleaner.lazyMigrateDupCountLN(this, this.dupCountLNRef, proactiveMigration);
            }
        }
        return super.logInternal(logManager, allowDeltas, isProvisional, proactiveMigration, backgroundIO, parent);
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += LogUtils.getByteArrayLogSize(this.dupKey);
        size += LogUtils.getBooleanLogSize();
        if (this.dupCountLNRef != null) {
            size += this.dupCountLNRef.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeByteArray(logBuffer, this.dupKey);
        boolean dupCountLNRefExists = this.dupCountLNRef != null;
        LogUtils.writeBoolean(logBuffer, dupCountLNRefExists);
        if (dupCountLNRefExists) {
            this.dupCountLNRef.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer);
        boolean dupCountLNRefExists = LogUtils.readBoolean(itemBuffer);
        if (dupCountLNRefExists) {
            this.dupCountLNRef.readFromLog(itemBuffer, entryTypeVersion);
        } else {
            this.dupCountLNRef = null;
        }
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
        if (this.dupCountLNRef != null) {
            this.dupCountLNRef.dumpLog(sb, true);
        }
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        if (this.dupCountLNRef == null) {
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<dupCountLN/>");
        } else {
            sb.append(this.dupCountLNRef.dumpString(nSpaces + 4, true));
        }
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "DIN";
    }

    static {
        $assertionsDisabled = !DIN.class.desiredAssertionStatus();
    }
}

