/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.raw.RawObject;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReadOnlyCatalog
implements Catalog {
    private List<Format> formatList;
    private Map<String, Format> formatMap;

    ReadOnlyCatalog(List<Format> formatList, Map<String, Format> formatMap) {
        this.formatList = formatList;
        this.formatMap = formatMap;
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        return 1;
    }

    @Override
    public Format getFormat(int formatId) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw new IllegalStateException("Format does not exist: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Format does not exist: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        throw new IllegalStateException();
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        throw new IllegalStateException();
    }
}

