/*
 * Decompiled with CFR 0.152.
 */
package bloop.integrations.maven;

import bloop.config.Config;
import bloop.integrations.maven.MojoImplementation;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala.util.Either;
import scala_maven.AppLauncher;
import scala_maven.ExtendedScalaContinuousCompileMojo;

@Mojo(name="bloopInstall", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class BloopMojo
extends ExtendedScalaContinuousCompileMojo {
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Component
    private MavenPluginManager mavenPluginManager;
    @Parameter(property="bloop.configDirectory", defaultValue="${session.executionRootDirectory}/.bloop")
    private File bloopConfigDir;
    @Parameter(property="scala.artifactID", defaultValue="scala-compiler")
    private String scalaArtifactID;
    @Parameter(property="launcher")
    private String launcher;
    @Parameter(property="addRunArgs", name="addRunArgs")
    private String addRunArgs;
    @Parameter(property="bloop.executionFork", defaultValue="false")
    private boolean bloopExecutionFork;
    @Parameter(property="downloadSources", defaultValue="false")
    private boolean downloadSources;
    @Parameter(property="bloop.classpathOptions.bootLibrary", defaultValue="true")
    private boolean classpathOptionsBootLibrary;
    @Parameter(property="bloop.classpathOptions.compiler", defaultValue="false")
    private boolean classpathOptionsCompiler;
    @Parameter(property="bloop.classpathOptions.extra", defaultValue="false")
    private boolean classpathOptionsExtra;
    @Parameter(property="bloop.classpathOptions.autoBoot", defaultValue="true")
    private boolean classpathOptionsAutoBoot;
    @Parameter(property="bloop.classpathOptions.filterLibrary", defaultValue="true")
    private boolean classpathOptionsFilterLibrary;
    @Parameter(property="bloop.secondaryCacheDir", defaultValue="${session.executionRootDirectory}/.bloop/cache")
    private File secondaryCacheDir;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="compileOrder", defaultValue="Mixed")
    private CompileOrder compileOrder;
    private ModuleType moduleType;
    private List<String> javaCompilerArgs;
    private AppLauncher[] launchers;
    @Parameter(property="sourceDir", defaultValue="$mainSourceDir")
    private String sourceDir;
    protected String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Either<String, BloopMojo> either = MojoImplementation.initializeMojo(this.project, this.session, this.mojoExecution, this.mavenPluginManager, this.encoding);
        if (either.isLeft()) {
            this.getLog().warn((CharSequence)("Skipping configuration file generation: " + (String)either.left().get()));
            return;
        }
        BloopMojo bloopMojo = (BloopMojo)((Object)either.right().get());
        MojoImplementation.writeCompileAndTestConfiguration(bloopMojo, this.session, this.getLog());
    }

    public File[] getAllScalaJars() throws Exception {
        if (this.moduleType == ModuleType.SCALA) {
            File file = this.getLibraryJar();
            File file2 = this.getCompilerJar();
            Object[] objectArray = new File[]{file, file2};
            List list = this.getCompilerDependencies();
            list.remove(file);
            return (File[])ArrayUtils.addAll((Object[])objectArray, (Object[])list.toArray());
        }
        return new File[0];
    }

    public File getBloopConfigDir() {
        return this.bloopConfigDir;
    }

    public boolean shouldDownloadSources() {
        return this.downloadSources;
    }

    private Config.CompileOrder getCompileOrder() {
        if (this.moduleType == ModuleType.JAVA) {
            return Config.JavaThenScala$.MODULE$;
        }
        switch (this.compileOrder) {
            case JavaThenScala: {
                return Config.JavaThenScala$.MODULE$;
            }
            case ScalaThenJava: {
                return Config.ScalaThenJava$.MODULE$;
            }
        }
        return Config.Mixed$.MODULE$;
    }

    public Config.CompileSetup getCompileSetup() {
        return new Config.CompileSetup(this.getCompileOrder(), this.classpathOptionsBootLibrary, this.classpathOptionsCompiler, this.classpathOptionsExtra, this.classpathOptionsAutoBoot, this.classpathOptionsFilterLibrary);
    }

    public String getScalaArtifactID() {
        return this.scalaArtifactID;
    }

    public String getLauncher() {
        if (this.launcher == null) {
            return "";
        }
        return this.launcher;
    }

    public String getAddRunArgs() {
        if (this.addRunArgs == null) {
            return "";
        }
        return this.addRunArgs;
    }

    public AppLauncher[] getLaunchers() {
        if (this.launchers == null) {
            return new AppLauncher[0];
        }
        return this.launchers;
    }

    public List<String> getJavacArgs() throws Exception {
        List list = super.getJavacOptions();
        if (this.javaCompilerArgs != null) {
            list.addAll(this.javaCompilerArgs);
        }
        return list;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public void setJavaCompilerArgs(List<String> list) {
        this.javaCompilerArgs = list;
    }

    public static enum CompileOrder {
        Mixed,
        JavaThenScala,
        ScalaThenJava;

    }

    public static enum ModuleType {
        SCALA,
        JAVA;

    }
}

