/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apigateway.model.Resource;
import java.util.Map;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentId").build();
    private static final MarshallingInfo<String> PATHPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathPart").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<Map> RESOURCEMETHODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceMethods").build();
    private static final ResourceMarshaller instance = new ResourceMarshaller();

    public static ResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        if (resource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resource.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)resource.getParentId(), PARENTID_BINDING);
            protocolMarshaller.marshall((Object)resource.getPathPart(), PATHPART_BINDING);
            protocolMarshaller.marshall((Object)resource.getPath(), PATH_BINDING);
            protocolMarshaller.marshall(resource.getResourceMethods(), RESOURCEMETHODS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

