/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResetCacheParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheParameterGroupName;
    private Boolean resetAllParameters;
    private SdkInternalList<ParameterNameValue> parameterNameValues;

    public ResetCacheParameterGroupRequest() {
    }

    public ResetCacheParameterGroupRequest(String cacheParameterGroupName, List<ParameterNameValue> parameterNameValues) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        this.setParameterNameValues(parameterNameValues);
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public ResetCacheParameterGroupRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        return this;
    }

    public void setResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
    }

    public Boolean getResetAllParameters() {
        return this.resetAllParameters;
    }

    public ResetCacheParameterGroupRequest withResetAllParameters(Boolean resetAllParameters) {
        this.setResetAllParameters(resetAllParameters);
        return this;
    }

    public Boolean isResetAllParameters() {
        return this.resetAllParameters;
    }

    public List<ParameterNameValue> getParameterNameValues() {
        if (this.parameterNameValues == null) {
            this.parameterNameValues = new SdkInternalList();
        }
        return this.parameterNameValues;
    }

    public void setParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        if (parameterNameValues == null) {
            this.parameterNameValues = null;
            return;
        }
        this.parameterNameValues = new SdkInternalList(parameterNameValues);
    }

    public ResetCacheParameterGroupRequest withParameterNameValues(ParameterNameValue ... parameterNameValues) {
        if (this.parameterNameValues == null) {
            this.setParameterNameValues((Collection<ParameterNameValue>)new SdkInternalList(parameterNameValues.length));
        }
        for (ParameterNameValue ele : parameterNameValues) {
            this.parameterNameValues.add((Object)ele);
        }
        return this;
    }

    public ResetCacheParameterGroupRequest withParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        this.setParameterNameValues(parameterNameValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.getCacheParameterGroupName()).append(",");
        }
        if (this.getResetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.getResetAllParameters()).append(",");
        }
        if (this.getParameterNameValues() != null) {
            sb.append("ParameterNameValues: ").append(this.getParameterNameValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetCacheParameterGroupRequest)) {
            return false;
        }
        ResetCacheParameterGroupRequest other = (ResetCacheParameterGroupRequest)obj;
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getResetAllParameters() == null ^ this.getResetAllParameters() == null) {
            return false;
        }
        if (other.getResetAllParameters() != null && !other.getResetAllParameters().equals(this.getResetAllParameters())) {
            return false;
        }
        if (other.getParameterNameValues() == null ^ this.getParameterNameValues() == null) {
            return false;
        }
        return other.getParameterNameValues() == null || other.getParameterNameValues().equals(this.getParameterNameValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getResetAllParameters() == null ? 0 : this.getResetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParameterNameValues() == null ? 0 : this.getParameterNameValues().hashCode());
        return hashCode;
    }

    public ResetCacheParameterGroupRequest clone() {
        return (ResetCacheParameterGroupRequest)super.clone();
    }
}

