/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AaptOptions;
import com.android.builder.AaptRunner;
import com.android.builder.DexOptions;
import com.android.builder.ManifestDependency;
import com.android.builder.SdkParser;
import com.android.builder.SymbolFileProvider;
import com.android.builder.VariantConfiguration;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.BuildConfigGenerator;
import com.android.builder.internal.CommandLineRunner;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.FileGatherer;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.packaging.SigningException;
import com.android.builder.signing.CertificateInfo;
import com.android.builder.signing.KeystoreHelper;
import com.android.builder.signing.KeytoolException;
import com.android.builder.signing.SigningConfig;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class AndroidBuilder {
    private static final FullRevision MIN_PLATFORM_TOOLS_REV = new FullRevision(16, 0, 2);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public boolean processFile(File dependencyFile) {
            return true;
        }
    };
    private final SdkParser mSdkParser;
    private final ILogger mLogger;
    private final CommandLineRunner mCmdLineRunner;
    private final boolean mVerboseExec;
    private IAndroidTarget mTarget;

    public AndroidBuilder(@NonNull SdkParser sdkParser, @NonNull ILogger logger, boolean verboseExec) {
        this.mSdkParser = Preconditions.checkNotNull(sdkParser);
        this.mLogger = Preconditions.checkNotNull(logger);
        this.mVerboseExec = verboseExec;
        this.mCmdLineRunner = new CommandLineRunner(this.mLogger);
        FullRevision platformToolsRevision = this.mSdkParser.getPlatformToolsRevision();
        if (platformToolsRevision == null) {
            throw new IllegalArgumentException("The SDK Platform Tools revision could not be found. Make sure the component is installed.");
        }
        if (platformToolsRevision.compareTo(MIN_PLATFORM_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Platform Tools revision (%1$s) is too low. Minimum required is %2$s", platformToolsRevision, MIN_PLATFORM_TOOLS_REV));
        }
    }

    AndroidBuilder(@NonNull SdkParser sdkParser, @NonNull CommandLineRunner cmdLineRunner, @NonNull ILogger logger, boolean verboseExec) {
        this.mSdkParser = Preconditions.checkNotNull(sdkParser);
        this.mCmdLineRunner = Preconditions.checkNotNull(cmdLineRunner);
        this.mLogger = Preconditions.checkNotNull(logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTarget(@NonNull String target) {
        Preconditions.checkNotNull(target, "target cannot be null.");
        this.mTarget = this.mSdkParser.resolveTarget(target, this.mLogger);
        if (this.mTarget == null) {
            throw new RuntimeException("Unknown target: " + target);
        }
    }

    public int getTargetApiLevel() {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        return this.mTarget.getVersion().getApiLevel();
    }

    public List<String> getRuntimeClasspath() {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        ArrayList<String> classpath = Lists.newArrayList();
        classpath.add(this.mTarget.getPath(1));
        IAndroidTarget.IOptionalLibrary[] libs = this.mTarget.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(lib.getJarPath());
            }
        }
        if (this.mTarget.getVersion().getApiLevel() <= 15) {
            classpath.add(this.mSdkParser.getAnnotationsJar());
        }
        return classpath;
    }

    public AaptRunner getAaptRunner() {
        return new AaptRunner(this.mSdkParser.getAapt().getAbsolutePath(), this.mCmdLineRunner);
    }

    public void generateBuildConfig(@NonNull String packageName, boolean debuggable, @NonNull List<String> javaLines, @NonNull String sourceOutputDir) throws IOException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        BuildConfigGenerator generator = new BuildConfigGenerator(sourceOutputDir, packageName, debuggable);
        generator.generate(javaLines);
    }

    public void processManifest(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, int versionCode, String versionName, int minSdkVersion, int targetSdkVersion, @NonNull String outManifestLocation) {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(mainManifest, "mainManifest cannot be null.");
        Preconditions.checkNotNull(manifestOverlays, "manifestOverlays cannot be null.");
        Preconditions.checkNotNull(libraries, "libraries cannot be null.");
        Preconditions.checkNotNull(outManifestLocation, "outManifestLocation cannot be null.");
        try {
            Map<String, String> attributeInjection = this.getAttributeInjectionMap(versionCode, versionName, minSdkVersion, targetSdkVersion);
            if (manifestOverlays.isEmpty() && libraries.isEmpty()) {
                if (attributeInjection.isEmpty()) {
                    Files.copy(mainManifest, new File(outManifestLocation));
                } else {
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog(this.mLogger), null);
                    if (!merger.process(new File(outManifestLocation), mainManifest, new File[0], attributeInjection)) {
                        throw new RuntimeException();
                    }
                }
            } else {
                File outManifest = new File(outManifestLocation);
                if (!manifestOverlays.isEmpty()) {
                    ManifestMerger merger;
                    File mainManifestOut = outManifest;
                    if (!libraries.isEmpty()) {
                        mainManifestOut = File.createTempFile("manifestMerge", ".xml");
                        mainManifestOut.deleteOnExit();
                    }
                    if (!(merger = new ManifestMerger(MergerLog.wrapSdkLog(this.mLogger), null)).process(mainManifestOut, mainManifest, manifestOverlays.toArray(new File[manifestOverlays.size()]), attributeInjection)) {
                        throw new RuntimeException();
                    }
                    mainManifest = mainManifestOut;
                    attributeInjection = null;
                }
                if (!libraries.isEmpty()) {
                    this.mergeLibraryManifests(mainManifest, libraries, new File(outManifestLocation), attributeInjection);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processTestManifest(@NonNull String testPackageName, int minSdkVersion, @NonNull String testedPackageName, @NonNull String instrumentationRunner, @NonNull List<? extends ManifestDependency> libraries, @NonNull String outManifestLocation) {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(testPackageName, "testPackageName cannot be null.");
        Preconditions.checkNotNull(testedPackageName, "testedPackageName cannot be null.");
        Preconditions.checkNotNull(instrumentationRunner, "instrumentationRunner cannot be null.");
        Preconditions.checkNotNull(libraries, "libraries cannot be null.");
        Preconditions.checkNotNull(outManifestLocation, "outManifestLocation cannot be null.");
        if (!libraries.isEmpty()) {
            try {
                File generatedTestManifest = File.createTempFile("manifestMerge", ".xml");
                this.generateTestManifest(testPackageName, minSdkVersion, testedPackageName, instrumentationRunner, generatedTestManifest.getAbsolutePath());
                this.mergeLibraryManifests(generatedTestManifest, libraries, new File(outManifestLocation), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.generateTestManifest(testPackageName, minSdkVersion, testedPackageName, instrumentationRunner, outManifestLocation);
        }
    }

    private void generateTestManifest(String testPackageName, int minSdkVersion, String testedPackageName, String instrumentationRunner, String outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testPackageName, minSdkVersion, testedPackageName, instrumentationRunner);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getAttributeInjectionMap(int versionCode, String versionName, int minSdkVersion, int targetSdkVersion) {
        HashMap<String, String> attributeInjection = Maps.newHashMap();
        if (versionCode != -1) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionCode", Integer.toString(versionCode));
        }
        if (versionName != null) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionName", versionName);
        }
        if (minSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android minSdkVersion", Integer.toString(minSdkVersion));
        }
        if (targetSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android targetSdkVersion", Integer.toString(targetSdkVersion));
        }
        return attributeInjection;
    }

    private void mergeLibraryManifests(File mainManifest, Iterable<? extends ManifestDependency> directLibraries, File outManifest, Map<String, String> attributeInjection) throws IOException {
        ArrayList<File> manifests = Lists.newArrayList();
        for (ManifestDependency manifestDependency : directLibraries) {
            List<? extends ManifestDependency> subLibraries = manifestDependency.getManifestDependencies();
            if (subLibraries == null || subLibraries.size() == 0) {
                manifests.add(manifestDependency.getManifest());
                continue;
            }
            File mergeLibManifest = File.createTempFile("manifestMerge", ".xml");
            mergeLibManifest.deleteOnExit();
            this.mergeLibraryManifests(manifestDependency.getManifest(), subLibraries, mergeLibManifest, null);
            manifests.add(mergeLibManifest);
        }
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog(this.mLogger), null);
        if (!merger.process(outManifest, mainManifest, manifests.toArray(new File[manifests.size()]), attributeInjection)) {
            throw new RuntimeException();
        }
    }

    public void processResources(@NonNull File manifestFile, @NonNull File resFolder, @Nullable File assetsDir, @NonNull List<? extends SymbolFileProvider> libraries, @Nullable String packageOverride, @Nullable String sourceOutputDir, @Nullable String symbolOutputDir, @Nullable String resPackageOutput, @Nullable String proguardOutput, VariantConfiguration.Type type, boolean debuggable, @NonNull AaptOptions options) throws IOException, InterruptedException {
        List<String> noCompressList;
        String ignoreAssets;
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(manifestFile, "manifestFile cannot be null.");
        Preconditions.checkNotNull(resFolder, "resFolder cannot be null.");
        Preconditions.checkNotNull(libraries, "libraries cannot be null.");
        Preconditions.checkNotNull(options, "options cannot be null.");
        Preconditions.checkArgument(sourceOutputDir != null || resPackageOutput != null, "No output provided for aapt task");
        ArrayList<String> command = Lists.newArrayList();
        File aapt = this.mSdkParser.getAapt();
        if (aapt == null || !aapt.isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt.getAbsolutePath());
        command.add("package");
        if (this.mVerboseExec) {
            command.add("-v");
        }
        command.add("-f");
        command.add("--no-crunch");
        command.add("-I");
        command.add(this.mTarget.getPath(1));
        command.add("-M");
        command.add(manifestFile.getAbsolutePath());
        if (resFolder.isDirectory()) {
            command.add("-S");
            command.add(resFolder.getAbsolutePath());
        }
        if (assetsDir != null && assetsDir.isDirectory()) {
            command.add("-A");
            command.add(assetsDir.getAbsolutePath());
        }
        if (sourceOutputDir != null) {
            command.add("-m");
            command.add("-J");
            command.add(sourceOutputDir);
        }
        if (type != VariantConfiguration.Type.LIBRARY && resPackageOutput != null) {
            command.add("-F");
            command.add(resPackageOutput);
            if (proguardOutput != null) {
                command.add("-G");
                command.add(proguardOutput);
            }
        }
        if (debuggable) {
            command.add("--debug-mode");
        }
        if (type == VariantConfiguration.Type.DEFAULT && packageOverride != null) {
            command.add("--rename-manifest-package");
            command.add(packageOverride);
            this.mLogger.verbose("Inserting package '%s' in AndroidManifest.xml", packageOverride);
        }
        if (type == VariantConfiguration.Type.LIBRARY) {
            command.add("--non-constant-id");
        }
        if ((ignoreAssets = options.getIgnoreAssets()) != null) {
            command.add("---ignore-assets");
            command.add(ignoreAssets);
        }
        if ((noCompressList = options.getNoCompress()) != null) {
            for (String noCompress : noCompressList) {
                command.add("-0");
                command.add(noCompress);
            }
        }
        if (!(symbolOutputDir == null || type != VariantConfiguration.Type.LIBRARY && libraries.isEmpty())) {
            command.add("--output-text-symbols");
            command.add(symbolOutputDir);
        }
        this.mCmdLineRunner.runCmdLine(command);
        if (type != VariantConfiguration.Type.LIBRARY && !libraries.isEmpty()) {
            SymbolLoader fullSymbolValues = null;
            String appPackageName = packageOverride;
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(manifestFile);
            }
            ArrayListMultimap<String, SymbolLoader> libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : libraries) {
                String packageName;
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile() || appPackageName.equals(packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest()))) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(symbolOutputDir, "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put(packageName, libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get(string);
                SymbolWriter writer = new SymbolWriter(sourceOutputDir, string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void compileAllAidlFiles(@NonNull List<File> sourceFolders, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, ExecutionException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(sourceFolders, "sourceFolders cannot be null.");
        Preconditions.checkNotNull(sourceOutputDir, "sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, "importFolders cannot be null.");
        File aidl = this.mSdkParser.getAidlCompiler();
        if (aidl == null || !aidl.isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList<File> fullImportList = Lists.newArrayListWithCapacity(sourceFolders.size() + importFolders.size());
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl.getAbsolutePath(), this.mTarget.getPath(2), fullImportList, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(@NonNull File aidlFile, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(aidlFile, "aidlFile cannot be null.");
        Preconditions.checkNotNull(sourceOutputDir, "sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, "importFolders cannot be null.");
        File aidl = this.mSdkParser.getAidlCompiler();
        if (aidl == null || !aidl.isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl.getAbsolutePath(), this.mTarget.getPath(2), importFolders, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        processor.processFile(aidlFile);
    }

    public void compileAllRenderscriptFiles(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, int targetApi, boolean debugBuild, int optimLevel) throws IOException, InterruptedException, ExecutionException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(sourceFolders, "sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, "importFolders cannot be null.");
        Preconditions.checkNotNull(sourceOutputDir, "sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(resOutputDir, "resOutputDir cannot be null.");
        File renderscript = this.mSdkParser.getRenderscriptCompiler();
        if (renderscript == null || !renderscript.isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        FileGatherer fileGatherer = new FileGatherer();
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "rs", "fs");
        searcher.setUseExecutor(false);
        searcher.search(fileGatherer);
        List<File> renderscriptFiles = fileGatherer.getFiles();
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        String rsPath = this.mTarget.getPath(25);
        String rsClangPath = this.mTarget.getPath(26);
        File rawFolder = new File(resOutputDir, "raw");
        ArrayList<String> command = Lists.newArrayList();
        command.add(renderscript.getAbsolutePath());
        if (debugBuild) {
            command.add("-g");
        }
        command.add("-O");
        command.add(Integer.toString(optimLevel));
        command.add("-I");
        command.add(rsPath);
        command.add("-I");
        command.add(rsClangPath);
        for (File importPath : importFolders) {
            if (!importPath.isDirectory()) continue;
            command.add("-I");
            command.add(importPath.getAbsolutePath());
        }
        command.add("-p");
        command.add(sourceOutputDir.getAbsolutePath());
        command.add("-o");
        command.add(rawFolder.getAbsolutePath());
        command.add("-target-api");
        command.add(Integer.toString(targetApi < 11 ? 11 : targetApi));
        for (File sourceFile : renderscriptFiles) {
            command.add(sourceFile.getAbsolutePath());
        }
        this.mCmdLineRunner.runCmdLine(command);
    }

    @NonNull
    public List<File> getLeafFolders(@NonNull String extension, List<File> ... importFolders) {
        ArrayList<File> results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(@NonNull Iterable<File> classesLocation, @NonNull Iterable<File> libraries, @NonNull String outDexFile, @NonNull DexOptions dexOptions, boolean incremental) throws IOException, InterruptedException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(classesLocation, "classesLocation cannot be null.");
        Preconditions.checkNotNull(libraries, "libraries cannot be null.");
        Preconditions.checkNotNull(outDexFile, "outDexFile cannot be null.");
        Preconditions.checkNotNull(dexOptions, "dexOptions cannot be null.");
        ArrayList<String> command = Lists.newArrayList();
        File dx = this.mSdkParser.getDx();
        if (dx == null || !dx.isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx.getAbsolutePath());
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.isCoreLibrary()) {
            command.add("--core-library");
        }
        if (incremental) {
            command.add("--incremental");
            command.add("--no-strict");
        }
        command.add("--output");
        command.add(outDexFile);
        ArrayList<String> classesList = Lists.newArrayList();
        for (File f : classesLocation) {
            if (f == null || !f.exists()) continue;
            classesList.add(f.getAbsolutePath());
        }
        ArrayList<String> libraryList = Lists.newArrayList();
        for (File f : libraries) {
            if (f == null || !f.exists()) continue;
            libraryList.add(f.getAbsolutePath());
        }
        this.mLogger.info("dx command: %s", command.toString());
        this.mLogger.verbose("Dex class inputs: " + classesList, new Object[0]);
        command.addAll(classesList);
        this.mLogger.verbose("Dex library inputs: " + libraryList, new Object[0]);
        command.addAll(libraryList);
        this.mCmdLineRunner.runCmdLine(command);
    }

    public void packageApk(@NonNull String androidResPkgLocation, @NonNull String classesDexLocation, @NonNull List<File> packagedJars, @Nullable String javaResourcesLocation, @Nullable String jniLibsLocation, boolean jniDebugBuild, @Nullable SigningConfig signingConfig, @NonNull String outApkLocation) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, SigningException {
        Preconditions.checkState(this.mTarget != null, "Target not set.");
        Preconditions.checkNotNull(androidResPkgLocation, "androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull(classesDexLocation, "classesDexLocation cannot be null.");
        Preconditions.checkNotNull(outApkLocation, "outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo(signingConfig)) == null) {
            throw new SigningException("Failed to read key from keystore", new Object[0]);
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, classesDexLocation, certificateInfo, this.mLogger);
            packager.setJniDebugMode(jniDebugBuild);
            JavaResourceProcessor resProcessor = new JavaResourceProcessor(packager);
            if (javaResourcesLocation != null) {
                resProcessor.addSourceFolder(javaResourcesLocation);
            }
            for (File jar : packagedJars) {
                packager.addResourcesFromJar(jar);
            }
            if (jniLibsLocation != null) {
                packager.addNativeLibraries(jniLibsLocation);
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }
}

