/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.BuildConfig;
import com.android.builder.signing.SigningConfig;
import com.google.common.base.Objects;

public class BuildType
extends BuildConfig {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private boolean mDebuggable = false;
    private boolean mJniDebugBuild = false;
    private boolean mRenderscriptDebugBuild = false;
    private int mRenderscriptOptimLevel = 3;
    private String mPackageNameSuffix = null;
    private String mVersionNameSuffix = null;
    private boolean mRunProguard = false;
    private SigningConfig mSigningConfig = null;
    private boolean mZipAlign = true;

    public BuildType(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public BuildType setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
        return this;
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public BuildType setJniDebugBuild(boolean jniDebugBuild) {
        this.mJniDebugBuild = jniDebugBuild;
        return this;
    }

    public boolean isJniDebugBuild() {
        return this.mJniDebugBuild;
    }

    public boolean isRenderscriptDebugBuild() {
        return this.mRenderscriptDebugBuild;
    }

    public void setRenderscriptDebugBuild(boolean renderscriptDebugBuild) {
        this.mRenderscriptDebugBuild = renderscriptDebugBuild;
    }

    public int getRenderscriptOptimLevel() {
        return this.mRenderscriptOptimLevel;
    }

    public void setRenderscriptOptimLevel(int renderscriptOptimLevel) {
        this.mRenderscriptOptimLevel = renderscriptOptimLevel;
    }

    public BuildType setPackageNameSuffix(@Nullable String packageNameSuffix) {
        this.mPackageNameSuffix = packageNameSuffix;
        return this;
    }

    @Nullable
    public String getPackageNameSuffix() {
        return this.mPackageNameSuffix;
    }

    public BuildType setVersionNameSuffix(@Nullable String versionNameSuffix) {
        this.mVersionNameSuffix = versionNameSuffix;
        return this;
    }

    @Nullable
    public String getVersionNameSuffix() {
        return this.mVersionNameSuffix;
    }

    public BuildType setRunProguard(boolean runProguard) {
        this.mRunProguard = runProguard;
        return this;
    }

    public boolean isRunProguard() {
        return this.mRunProguard;
    }

    public BuildType setZipAlign(boolean zipAlign) {
        this.mZipAlign = zipAlign;
        return this;
    }

    public boolean isZipAlign() {
        return this.mZipAlign;
    }

    public BuildType setSigningConfig(@Nullable SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildType buildType = (BuildType)o;
        if (!this.mName.equals(buildType.mName)) {
            return false;
        }
        if (this.mDebuggable != buildType.mDebuggable) {
            return false;
        }
        if (this.mJniDebugBuild != buildType.mJniDebugBuild) {
            return false;
        }
        if (this.mRenderscriptDebugBuild != buildType.mRenderscriptDebugBuild) {
            return false;
        }
        if (this.mRenderscriptOptimLevel != buildType.mRenderscriptOptimLevel) {
            return false;
        }
        if (this.mRunProguard != buildType.mRunProguard) {
            return false;
        }
        if (this.mZipAlign != buildType.mZipAlign) {
            return false;
        }
        if (this.mPackageNameSuffix != null ? !this.mPackageNameSuffix.equals(buildType.mPackageNameSuffix) : buildType.mPackageNameSuffix != null) {
            return false;
        }
        if (this.mVersionNameSuffix != null ? !this.mVersionNameSuffix.equals(buildType.mVersionNameSuffix) : buildType.mVersionNameSuffix != null) {
            return false;
        }
        return !(this.mSigningConfig != null ? !this.mSigningConfig.equals(buildType.mSigningConfig) : buildType.mSigningConfig != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + (this.mDebuggable ? 1 : 0);
        result = 31 * result + (this.mJniDebugBuild ? 1 : 0);
        result = 31 * result + (this.mRenderscriptDebugBuild ? 1 : 0);
        result = 31 * result + this.mRenderscriptOptimLevel;
        result = 31 * result + (this.mPackageNameSuffix != null ? this.mPackageNameSuffix.hashCode() : 0);
        result = 31 * result + (this.mVersionNameSuffix != null ? this.mVersionNameSuffix.hashCode() : 0);
        result = 31 * result + (this.mRunProguard ? 1 : 0);
        result = 31 * result + (this.mZipAlign ? 1 : 0);
        result = 31 * result + (this.mSigningConfig != null ? this.mSigningConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.mName).add("debuggable", this.mDebuggable).add("jniDebugBuild", this.mJniDebugBuild).add("renderscriptDebugBuild", this.mRenderscriptDebugBuild).add("renderscriptOptimLevel", this.mRenderscriptOptimLevel).add("packageNameSuffix", this.mPackageNameSuffix).add("versionNameSuffix", this.mVersionNameSuffix).add("runProguard", this.mRunProguard).add("zipAlign", this.mZipAlign).add("signingConfig", this.mSigningConfig).toString();
    }
}

