/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AndroidDependency;
import com.google.common.base.Objects;
import java.io.File;

public abstract class BundleDependency
implements AndroidDependency {
    private final String mName;
    private final File mBundleFolder;

    protected BundleDependency(@NonNull File bundleFolder, @Nullable String name) {
        this.mName = name;
        this.mBundleFolder = bundleFolder;
    }

    protected BundleDependency(@NonNull File bundleFolder) {
        this(bundleFolder, null);
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public File getManifest() {
        return new File(this.mBundleFolder, "AndroidManifest.xml");
    }

    @Override
    public File getSymbolFile() {
        return new File(this.mBundleFolder, "R.txt");
    }

    @Override
    public File getFolder() {
        return this.mBundleFolder;
    }

    @Override
    public File getJarFile() {
        return new File(this.mBundleFolder, "classes.jar");
    }

    @Override
    public File getResFolder() {
        return new File(this.mBundleFolder, "res");
    }

    @Override
    public File getAssetsFolder() {
        return new File(this.mBundleFolder, "assets");
    }

    @Override
    public File getJniFolder() {
        return new File(this.mBundleFolder, "jni");
    }

    @Override
    public File getAidlFolder() {
        return new File(this.mBundleFolder, "aidl");
    }

    @Override
    public File getRenderscriptFolder() {
        return new File(this.mBundleFolder, "rs");
    }

    @Override
    public File getProguardRules() {
        return new File(this.mBundleFolder, "proguard.txt");
    }

    @Override
    public File getLintJar() {
        return new File(this.mBundleFolder, "lint.jar");
    }

    public File getBundleFolder() {
        return this.mBundleFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleDependency that = (BundleDependency)o;
        return Objects.equal(this.mName, that.mName);
    }

    public int hashCode() {
        return this.mName != null ? this.mName.hashCode() : 0;
    }
}

