/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.builder.SdkParser;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class DefaultSdkParser
implements SdkParser {
    private final String mSdkLocation;
    private SdkManager mManager;
    private File mTools;
    private File mPlatformTools;
    private final Map<String, File> mToolsMap = Maps.newHashMapWithExpectedSize(6);

    public DefaultSdkParser(@NonNull String sdkLocation) {
        this.mSdkLocation = !sdkLocation.endsWith(File.separator) ? sdkLocation + File.separator : sdkLocation;
    }

    @Override
    public IAndroidTarget resolveTarget(@NonNull String target, @NonNull ILogger logger) {
        if (this.mManager == null) {
            this.mManager = SdkManager.createManager(this.mSdkLocation, logger);
            if (this.mManager == null) {
                throw new RuntimeException("failed to parse SDK!");
            }
        }
        return this.mManager.getTargetFromHashString(target);
    }

    @Override
    public String getAnnotationsJar() {
        return this.mSdkLocation + "tools" + '/' + "support" + '/' + "annotations.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FullRevision getPlatformToolsRevision() {
        FullRevision fullRevision;
        File platformTools = this.getPlatformToolsFolder();
        if (!platformTools.isDirectory()) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(platformTools, "source.properties")), Charsets.UTF_8);
            Properties props = new Properties();
            props.load(reader);
            String value = props.getProperty("Pkg.Revision");
            fullRevision = FullRevision.parseRevision(value);
        }
        catch (FileNotFoundException ignore) {
            Closeables.closeQuietly(reader);
            return null;
            catch (IOException ignore2) {
                Closeables.closeQuietly(reader);
                return null;
                catch (NumberFormatException numberFormatException) {
                    Closeables.closeQuietly(reader);
                    return null;
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(reader);
                        throw throwable;
                    }
                }
            }
        }
        Closeables.closeQuietly(reader);
        return fullRevision;
    }

    @Override
    public File getAapt() {
        return this.getPlatformTool(SdkConstants.FN_AAPT);
    }

    @Override
    public File getAidlCompiler() {
        return this.getPlatformTool(SdkConstants.FN_AIDL);
    }

    @Override
    public File getRenderscriptCompiler() {
        return this.getPlatformTool(SdkConstants.FN_RENDERSCRIPT);
    }

    @Override
    public File getDx() {
        return this.getPlatformTool(SdkConstants.FN_DX);
    }

    @Override
    public File getZipAlign() {
        return this.getTool(SdkConstants.FN_ZIPALIGN);
    }

    @Override
    public File getAdb() {
        return this.getPlatformTool(SdkConstants.FN_ADB);
    }

    private File getPlatformTool(String filename) {
        File f = this.mToolsMap.get(filename);
        if (f == null) {
            File platformTools = this.getPlatformToolsFolder();
            if (!platformTools.isDirectory()) {
                return null;
            }
            f = new File(platformTools, filename);
            this.mToolsMap.put(filename, f);
        }
        return f;
    }

    private File getTool(String filename) {
        File f = this.mToolsMap.get(filename);
        if (f == null) {
            File platformTools = this.getToolsFolder();
            if (!platformTools.isDirectory()) {
                return null;
            }
            f = new File(platformTools, filename);
            this.mToolsMap.put(filename, f);
        }
        return f;
    }

    private File getPlatformToolsFolder() {
        if (this.mPlatformTools == null) {
            this.mPlatformTools = new File(this.mSdkLocation, "platform-tools");
        }
        return this.mPlatformTools;
    }

    private File getToolsFolder() {
        if (this.mTools == null) {
            this.mTools = new File(this.mSdkLocation, "tools");
        }
        return this.mTools;
    }
}

