/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.builder.SdkParser;
import com.android.builder.internal.FakeAndroidTarget;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;

public class PlatformSdkParser
implements SdkParser {
    private final String mPlatformRootFolder;
    private File mHostTools;
    private final Map<String, File> mToolsMap = Maps.newHashMapWithExpectedSize(6);
    private File mDx;
    private File mAdb;

    PlatformSdkParser(@NonNull String sdkLocation) {
        this.mPlatformRootFolder = sdkLocation;
    }

    @Override
    public IAndroidTarget resolveTarget(String target, ILogger logger) {
        return new FakeAndroidTarget(this.mPlatformRootFolder, target);
    }

    @Override
    public String getAnnotationsJar() {
        String host;
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            host = "darwin-x86";
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            host = "linux";
        } else {
            throw new IllegalStateException("Windows is not supported for platform development");
        }
        return this.mPlatformRootFolder + "/out/host/" + host + "/framework/annotations.jar";
    }

    @Override
    public FullRevision getPlatformToolsRevision() {
        return new FullRevision(99);
    }

    @Override
    public File getAapt() {
        return this.getTool(SdkConstants.FN_AAPT);
    }

    @Override
    public File getAidlCompiler() {
        return this.getTool(SdkConstants.FN_AIDL);
    }

    @Override
    public File getRenderscriptCompiler() {
        return this.getTool(SdkConstants.FN_RENDERSCRIPT);
    }

    @Override
    public File getDx() {
        if (this.mDx == null) {
            this.mDx = new File(this.mPlatformRootFolder, "prebuilts/sdk/tools/dx");
        }
        return this.mDx;
    }

    @Override
    public File getZipAlign() {
        return this.getTool(SdkConstants.FN_ZIPALIGN);
    }

    @Override
    public File getAdb() {
        if (this.mAdb == null) {
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mAdb = new File(this.mPlatformRootFolder, "out/host/darwin-x86/bin/adb");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mAdb = new File(this.mPlatformRootFolder, "out/host/linux-x86/bin/adb");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
        }
        return this.mAdb;
    }

    private File getTool(String filename) {
        File f = this.mToolsMap.get(filename);
        if (f == null) {
            File platformTools = this.getHostToolsFolder();
            if (!platformTools.isDirectory()) {
                return null;
            }
            f = new File(platformTools, filename);
            this.mToolsMap.put(filename, f);
        }
        return f;
    }

    private File getHostToolsFolder() {
        if (this.mHostTools == null) {
            File tools = new File(this.mPlatformRootFolder, "prebuilts/sdk/tools");
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mHostTools = new File(tools, "darwin");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mHostTools = new File(tools, "linux");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
        }
        return this.mHostTools;
    }
}

