/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AndroidDependency;
import com.android.builder.BuildType;
import com.android.builder.DefaultManifestParser;
import com.android.builder.JarDependency;
import com.android.builder.ManifestParser;
import com.android.builder.ProductFlavor;
import com.android.builder.SourceProvider;
import com.android.builder.resources.AssetSet;
import com.android.builder.resources.ResourceSet;
import com.android.builder.signing.SigningConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VariantConfiguration {
    private static final ManifestParser sManifestParser = new DefaultManifestParser();
    private final ProductFlavor mDefaultConfig;
    private final SourceProvider mDefaultSourceProvider;
    private final BuildType mBuildType;
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<ProductFlavor> mFlavorConfigs = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    private final Type mType;
    private final VariantConfiguration mTestedConfig;
    private AndroidDependency mOutput;
    private ProductFlavor mMergedFlavor;
    private final Set<JarDependency> mJars = Sets.newHashSet();
    private final List<AndroidDependency> mDirectLibraries = Lists.newArrayList();
    private final List<AndroidDependency> mFlatLibraries = Lists.newArrayList();
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";

    @Nullable
    public static String getManifestPackage(@NonNull File manifestFile) {
        return sManifestParser.getPackage(manifestFile);
    }

    public VariantConfiguration(@NonNull ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, @NonNull SourceProvider buildTypeSourceProvider) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, Type.DEFAULT, null);
    }

    public VariantConfiguration(@NonNull ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, @NonNull SourceProvider buildTypeSourceProvider, @NonNull Type type) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, null);
    }

    public VariantConfiguration(@NonNull ProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildType buildType, SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable VariantConfiguration testedConfig) {
        this.mDefaultConfig = Preconditions.checkNotNull(defaultConfig);
        this.mDefaultSourceProvider = Preconditions.checkNotNull(defaultSourceProvider);
        this.mBuildType = Preconditions.checkNotNull(buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = Preconditions.checkNotNull(type);
        this.mTestedConfig = testedConfig;
        Preconditions.checkState(this.mType != Type.TEST || this.mTestedConfig != null);
        this.mMergedFlavor = this.mDefaultConfig;
        if (testedConfig != null && testedConfig.mType == Type.LIBRARY && testedConfig.mOutput != null) {
            this.mDirectLibraries.add(testedConfig.mOutput);
        }
        this.validate();
    }

    public VariantConfiguration addProductFlavor(@NonNull ProductFlavor productFlavor, @NonNull SourceProvider sourceProvider) {
        this.mFlavorConfigs.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mMergedFlavor = productFlavor.mergeOver(this.mMergedFlavor);
        return this;
    }

    public VariantConfiguration setJarDependencies(List<JarDependency> jars) {
        this.mJars.addAll(jars);
        return this;
    }

    public Collection<JarDependency> getJars() {
        return this.mJars;
    }

    public VariantConfiguration setAndroidDependencies(@NonNull List<AndroidDependency> directLibraries) {
        if (directLibraries != null) {
            this.mDirectLibraries.addAll(directLibraries);
        }
        this.resolveIndirectLibraryDependencies(this.mDirectLibraries, this.mFlatLibraries);
        return this;
    }

    public VariantConfiguration setOutput(AndroidDependency output) {
        this.mOutput = output;
        return this;
    }

    public ProductFlavor getDefaultConfig() {
        return this.mDefaultConfig;
    }

    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    public ProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    public BuildType getBuildType() {
        return this.mBuildType;
    }

    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavorConfigs.isEmpty();
    }

    public List<ProductFlavor> getFlavorConfigs() {
        return this.mFlavorConfigs;
    }

    public Iterable<SourceProvider> getFlavorSourceSets() {
        return this.mFlavorSourceProviders;
    }

    public boolean hasLibraries() {
        return !this.mDirectLibraries.isEmpty();
    }

    @NonNull
    public List<AndroidDependency> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    @NonNull
    public List<AndroidDependency> getAllLibraries() {
        return this.mFlatLibraries;
    }

    public List<File> getPackagedJars() {
        ArrayList<File> jars = Lists.newArrayListWithCapacity(this.mJars.size() + this.mFlatLibraries.size());
        for (JarDependency jar : this.mJars) {
            File jarFile = new File(jar.getLocation());
            if (!jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (AndroidDependency androidDependency : this.mFlatLibraries) {
            File libJar = androidDependency.getJarFile();
            if (!libJar.exists()) continue;
            jars.add(libJar);
        }
        return jars;
    }

    public Type getType() {
        return this.mType;
    }

    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    void resolveIndirectLibraryDependencies(List<AndroidDependency> directDependencies, List<AndroidDependency> outFlatDependencies) {
        if (directDependencies == null) {
            return;
        }
        for (int i = directDependencies.size() - 1; i >= 0; --i) {
            AndroidDependency library = directDependencies.get(i);
            List<AndroidDependency> dependencies = library.getDependencies();
            this.resolveIndirectLibraryDependencies(dependencies, outFlatDependencies);
            if (outFlatDependencies.contains(library)) continue;
            outFlatDependencies.add(0, library);
        }
    }

    public String getOriginalPackageName() {
        if (this.mType == Type.TEST) {
            return this.getPackageName();
        }
        return this.getPackageFromManifest();
    }

    public String getPackageName() {
        String packageName;
        if (this.mType == Type.TEST) {
            packageName = this.mMergedFlavor.getTestPackageName();
            if (packageName == null) {
                String testedPackage = this.mTestedConfig.getPackageName();
                packageName = testedPackage + ".test";
            }
        } else {
            packageName = this.getPackageOverride();
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
        }
        return packageName;
    }

    public String getTestedPackageName() {
        if (this.mType == Type.TEST) {
            if (this.mTestedConfig.mType == Type.LIBRARY) {
                return this.getPackageName();
            }
            return this.mTestedConfig.getPackageName();
        }
        return null;
    }

    public String getPackageOverride() {
        String packageName = this.mMergedFlavor.getPackageName();
        String packageSuffix = this.mBuildType.getPackageNameSuffix();
        if (packageSuffix != null && packageSuffix.length() > 0) {
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
            packageName = packageSuffix.charAt(0) == '.' ? packageName + packageSuffix : packageName + '.' + packageSuffix;
        }
        return packageName;
    }

    public String getVersionName() {
        String versionName = this.mMergedFlavor.getVersionName();
        String versionSuffix = this.mBuildType.getVersionNameSuffix();
        if (versionSuffix != null && versionSuffix.length() > 0) {
            if (versionName == null) {
                versionName = this.getVersionNameFromManifest();
            }
            versionName = versionName + versionSuffix;
        }
        return versionName;
    }

    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (runner = config.mMergedFlavor.getTestInstrumentationRunner()) != null ? runner : DEFAULT_TEST_RUNNER;
    }

    public String getPackageFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getPackage(manifestLocation);
    }

    public String getVersionNameFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getVersionName(manifestLocation);
    }

    public int getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        int minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == -1) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            minSdkVersion = sManifestParser.getMinSdkVersion(manifestLocation);
        }
        return minSdkVersion;
    }

    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest != null && defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    @NonNull
    public List<File> getManifestOverlays() {
        File typeLocation;
        ArrayList<File> inputs = Lists.newArrayList();
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()) != null && typeLocation.isFile()) {
            inputs.add(typeLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (f == null || !f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    @NonNull
    public List<ResourceSet> getResourceSets(@Nullable File generatedResFolder) {
        ArrayList<ResourceSet> resourceSets = Lists.newArrayList();
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            AndroidDependency dependency = this.mFlatLibraries.get(n);
            File resFolder = dependency.getResFolder();
            if (resFolder == null) continue;
            ResourceSet resourceSet = new ResourceSet(dependency.getFolder().getName());
            resourceSet.addSource(resFolder);
            resourceSets.add(resourceSet);
        }
        Set<File> mainResDirs = this.mDefaultSourceProvider.getResourcesDirectories();
        ResourceSet resourceSet = new ResourceSet("main");
        resourceSet.addSources(mainResDirs);
        if (generatedResFolder != null) {
            resourceSet.addSource(generatedResFolder);
        }
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Set<File> flavorResDirs = sourceProvider.getResourcesDirectories();
            resourceSet = new ResourceSet(this.mFlavorConfigs.get(n).getName());
            resourceSet.addSources(flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Set<File> typeResDirs = this.mBuildTypeSourceProvider.getResourcesDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName());
            resourceSet.addSources(typeResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    @NonNull
    public List<AssetSet> getAssetSets() {
        ArrayList<AssetSet> assetSets = Lists.newArrayList();
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            AndroidDependency dependency = this.mFlatLibraries.get(n);
            File assetFolder = dependency.getAssetsFolder();
            if (assetFolder == null) continue;
            AssetSet assetSet = new AssetSet(dependency.getFolder().getName());
            assetSet.addSource(assetFolder);
            assetSets.add(assetSet);
        }
        Set<File> mainResDirs = this.mDefaultSourceProvider.getAssetsDirectories();
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources(mainResDirs);
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Set<File> flavorResDirs = sourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mFlavorConfigs.get(n).getName());
            assetSet.addSources(flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Set<File> typeResDirs = this.mBuildTypeSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources(typeResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    @NonNull
    public List<File> getRenderscriptImports() {
        ArrayList<File> list = Lists.newArrayList();
        for (AndroidDependency lib : this.mFlatLibraries) {
            File rsLib = lib.getRenderscriptFolder();
            if (rsLib == null || !rsLib.isDirectory()) continue;
            list.add(rsLib);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptSourceList() {
        ArrayList<File> sourceList = Lists.newArrayList();
        sourceList.addAll(this.mDefaultSourceProvider.getRenderscriptDirectories());
        if (this.mType != Type.TEST) {
            sourceList.addAll(this.mBuildTypeSourceProvider.getRenderscriptDirectories());
        }
        if (this.hasFlavors()) {
            for (SourceProvider flavorSourceSet : this.mFlavorSourceProviders) {
                sourceList.addAll(flavorSourceSet.getRenderscriptDirectories());
            }
        }
        return sourceList;
    }

    @NonNull
    public List<File> getAidlImports() {
        ArrayList<File> list = Lists.newArrayList();
        for (AndroidDependency lib : this.mFlatLibraries) {
            File aidlLib = lib.getAidlFolder();
            if (aidlLib == null || !aidlLib.isDirectory()) continue;
            list.add(aidlLib);
        }
        return list;
    }

    @NonNull
    public List<File> getAidlSourceList() {
        ArrayList<File> sourceList = Lists.newArrayList();
        sourceList.addAll(this.mDefaultSourceProvider.getAidlDirectories());
        if (this.mType != Type.TEST) {
            sourceList.addAll(this.mBuildTypeSourceProvider.getAidlDirectories());
        }
        if (this.hasFlavors()) {
            for (SourceProvider flavorSourceSet : this.mFlavorSourceProviders) {
                sourceList.addAll(flavorSourceSet.getAidlDirectories());
            }
        }
        return sourceList;
    }

    public Set<File> getCompileClasspath() {
        HashSet<File> classpath = Sets.newHashSet();
        for (AndroidDependency lib : this.mFlatLibraries) {
            classpath.add(lib.getJarFile());
        }
        for (JarDependency jar : this.mJars) {
            classpath.add(new File(jar.getLocation()));
        }
        return classpath;
    }

    public List<String> getBuildConfigLines() {
        ArrayList<String> fullList = Lists.newArrayList();
        List<String> list = this.mDefaultConfig.getBuildConfig();
        if (!list.isEmpty()) {
            fullList.add("// lines from default config.");
            fullList.addAll(list);
        }
        if (!(list = this.mBuildType.getBuildConfig()).isEmpty()) {
            fullList.add("// lines from build type: " + this.mBuildType.getName());
            fullList.addAll(list);
        }
        for (ProductFlavor flavor : this.mFlavorConfigs) {
            list = flavor.getBuildConfig();
            if (list.isEmpty()) continue;
            fullList.add("// lines from product flavor: " + flavor.getName());
            fullList.addAll(list);
        }
        return fullList;
    }

    public SigningConfig getSigningConfig() {
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    protected void validate() {
        File manifest;
        if (this.mType != Type.TEST && !(manifest = this.mDefaultSourceProvider.getManifestFile()).isFile()) {
            throw new IllegalArgumentException("Main Manifest missing from " + manifest.getAbsolutePath());
        }
    }

    public static enum Type {
        DEFAULT,
        LIBRARY,
        TEST;

    }
}

