/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.TemplateProcessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class BuildConfigGenerator {
    private static final String TEMPLATE = "BuildConfig.template";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_DEBUG = "#DEBUG#";
    private static final String PH_LINES = "#ADDITIONAL_LINES#";
    private final String mGenFolder;
    private final String mAppPackage;
    private final boolean mDebug;
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";

    public BuildConfigGenerator(@NonNull String genFolder, @NonNull String appPackage, boolean debug) {
        this.mGenFolder = Preconditions.checkNotNull(genFolder);
        this.mAppPackage = Preconditions.checkNotNull(appPackage);
        this.mDebug = debug;
    }

    public File getFolderPath() {
        File genFolder = new File(this.mGenFolder);
        return new File(genFolder, this.mAppPackage.replace('.', File.separatorChar));
    }

    public File getBuildConfigFile() {
        File folder = this.getFolderPath();
        return new File(folder, BUILD_CONFIG_NAME);
    }

    public void generate(@Nullable List<String> additionalLines) throws IOException {
        HashMap<String, String> map = Maps.newHashMap();
        map.put(PH_PACKAGE, this.mAppPackage);
        map.put(PH_DEBUG, Boolean.toString(this.mDebug));
        if (additionalLines != null) {
            StringBuilder sb = new StringBuilder();
            for (String line : additionalLines) {
                sb.append("    ").append(line).append('\n');
            }
            map.put(PH_LINES, sb.toString());
        } else {
            map.put(PH_LINES, "");
        }
        File pkgFolder = this.getFolderPath();
        if (!pkgFolder.isDirectory()) {
            pkgFolder.mkdirs();
        }
        File buildConfigJava = new File(pkgFolder, BUILD_CONFIG_NAME);
        TemplateProcessor processor = new TemplateProcessor(BuildConfigGenerator.class.getResourceAsStream(TEMPLATE), map);
        processor.generate(buildConfigJava);
    }
}

