/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.Nullable;
import com.android.sdklib.util.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;

public class CommandLineRunner {
    private final ILogger mLogger;

    public CommandLineRunner(ILogger logger) {
        this.mLogger = logger;
    }

    public void runCmdLine(List<String> command) throws IOException, InterruptedException {
        String[] cmdArray = command.toArray(new String[command.size()]);
        this.runCmdLine(cmdArray);
    }

    public void runCmdLine(String[] command) throws IOException, InterruptedException {
        this.printCommand(command);
        Process process = Runtime.getRuntime().exec(command);
        if (this.grabProcessOutput(process) != 0) {
            throw new RuntimeException(String.format("Running %s failed. See output", command[0]));
        }
    }

    private int grabProcessOutput(Process process) throws InterruptedException {
        OutputGrabber grabber = new OutputGrabber();
        int exitCode = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_READERS, grabber);
        if (exitCode == 0 && grabber.foundError()) {
            this.mLogger.error(null, "Process output to error stream but exitCode is " + exitCode, new Object[0]);
            exitCode = -42;
        }
        return exitCode;
    }

    private void printCommand(String[] command) {
        this.mLogger.info("command: " + Joiner.on(' ').join(command), new Object[0]);
    }

    private class OutputGrabber
    implements GrabProcessOutput.IProcessOutput {
        private boolean mFoundError = false;

        private OutputGrabber() {
        }

        @Override
        public void out(@Nullable String line) {
            if (line != null) {
                CommandLineRunner.this.mLogger.info(line, new Object[0]);
            }
        }

        @Override
        public void err(@Nullable String line) {
            if (line != null) {
                CommandLineRunner.this.mLogger.error(null, line, new Object[0]);
                this.mFoundError = true;
            }
        }

        private boolean foundError() {
            return this.mFoundError;
        }
    }
}

