/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.SdkConstants;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.util.SparseArray;
import java.util.Map;

public class FakeAndroidTarget
implements IAndroidTarget {
    private final String mSdkLocation;
    private final SparseArray<String> mPaths = new SparseArray();
    private final int mApiLevel;

    public FakeAndroidTarget(String sdkLocation, String target) {
        this.mSdkLocation = sdkLocation;
        this.mApiLevel = this.getApiLevel(target);
        String apiPrebuilts = this.mSdkLocation + "/prebuilts/sdk/" + Integer.toString(this.mApiLevel) + "/";
        String rsPrebuilts = this.mSdkLocation + "/prebuilts/sdk/renderscript/";
        this.mPaths.put(1, apiPrebuilts + "android.jar");
        this.mPaths.put(2, apiPrebuilts + "framework.aidl");
        this.mPaths.put(25, rsPrebuilts + SdkConstants.OS_FRAMEWORK_RS);
        this.mPaths.put(26, rsPrebuilts + SdkConstants.OS_FRAMEWORK_RS_CLANG);
    }

    private int getApiLevel(String target) {
        if (target.startsWith("android-")) {
            return Integer.parseInt(target.substring("android-".length()));
        }
        throw new IllegalArgumentException("Android target '%s' is not recognized.");
    }

    @Override
    public String getPath(int pathId) {
        return this.mPaths.get(pathId);
    }

    @Override
    public String getLocation() {
        return this.mSdkLocation;
    }

    @Override
    public String getVendor() {
        return "android";
    }

    @Override
    public String getName() {
        return "android";
    }

    @Override
    public String getFullName() {
        return "android";
    }

    @Override
    public String getClasspathName() {
        return "android";
    }

    @Override
    public String getShortClasspathName() {
        return "android";
    }

    @Override
    public String getDescription() {
        return "android";
    }

    @Override
    public AndroidVersion getVersion() {
        return new AndroidVersion(this.mApiLevel, null);
    }

    @Override
    public String getVersionName() {
        return "Android API level " + this.mApiLevel;
    }

    @Override
    public int getRevision() {
        return 1;
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public boolean hasRenderingLibrary() {
        return false;
    }

    @Override
    public String[] getSkins() {
        return new String[0];
    }

    @Override
    public String getDefaultSkin() {
        return null;
    }

    @Override
    public IAndroidTarget.IOptionalLibrary[] getOptionalLibraries() {
        return new IAndroidTarget.IOptionalLibrary[0];
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[0];
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public Integer getProperty(String name, Integer defaultValue) {
        return null;
    }

    @Override
    public Boolean getProperty(String name, Boolean defaultValue) {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public int getUsbVendorId() {
        return 0;
    }

    @Override
    public ISystemImage[] getSystemImages() {
        return new ISystemImage[0];
    }

    @Override
    public ISystemImage getSystemImage(String abiType) {
        return null;
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        return false;
    }

    @Override
    public String hashString() {
        return "android-" + this.mApiLevel;
    }

    @Override
    public int compareTo(IAndroidTarget iAndroidTarget) {
        FakeAndroidTarget that = (FakeAndroidTarget)iAndroidTarget;
        return this.mSdkLocation.compareTo(that.mSdkLocation);
    }
}

