/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

class TemplateProcessor {
    private final InputStream mTemplateStream;
    private final Map<String, String> mPlaceHolderMap;

    public TemplateProcessor(@NonNull InputStream templateStream, @NonNull Map<String, String> placeHolderMap) {
        this.mTemplateStream = Preconditions.checkNotNull(templateStream);
        this.mPlaceHolderMap = Preconditions.checkNotNull(placeHolderMap);
    }

    public void generate(File outputFile) throws IOException {
        String template = this.readEmbeddedTextFile(this.mTemplateStream);
        String content = this.replaceParameters(template, this.mPlaceHolderMap);
        this.writeFile(outputFile, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEmbeddedTextFile(InputStream templateStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(templateStream, Charsets.UTF_8);
        try {
            String string = CharStreams.toString(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    private void writeFile(File file, String content) throws IOException {
        Files.write(content, file, Charsets.UTF_8);
    }

    private String replaceParameters(String str, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            str = str.replaceAll(entry.getKey(), value);
        }
        return str;
    }
}

