/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.internal.TemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class TestManifestGenerator {
    private static final String TEMPLATE = "AndroidManifest.template";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_MIN_SDK_VERSION = "#MINSDKVERSION#";
    private static final String PH_TESTED_PACKAGE = "#TESTEDPACKAGE#";
    private static final String PH_TEST_RUNNER = "#TESTRUNNER#";
    private final String mOutputFile;
    private final String mPackageName;
    private final int mMinSdkVersion;
    private final String mTestedPackageName;
    private final String mTestRunnerName;

    public TestManifestGenerator(@NonNull String outputFile, @NonNull String packageName, int minSdkVersion, @NonNull String testedPackageName, @NonNull String testRunnerName) {
        this.mOutputFile = outputFile;
        this.mPackageName = packageName;
        this.mMinSdkVersion = minSdkVersion;
        this.mTestedPackageName = testedPackageName;
        this.mTestRunnerName = testRunnerName;
    }

    public void generate() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PH_PACKAGE, this.mPackageName);
        map.put(PH_MIN_SDK_VERSION, Integer.toString(this.mMinSdkVersion));
        map.put(PH_TESTED_PACKAGE, this.mTestedPackageName);
        map.put(PH_TEST_RUNNER, this.mTestRunnerName);
        TemplateProcessor processor = new TemplateProcessor(TestManifestGenerator.class.getResourceAsStream(TEMPLATE), map);
        processor.generate(new File(this.mOutputFile));
    }
}

