/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;

class FileEntity {
    private static final byte[] sBuffer = new byte[4096];
    private final File mFile;
    private final long mLastModified;
    private long mLength;
    private String mSha1;

    FileEntity(File file, long lastModified, long length, String sha1) {
        this.mFile = file;
        this.mLastModified = lastModified;
        this.mLength = length;
        this.mSha1 = sha1;
    }

    FileEntity(File file) {
        this.mFile = file;
        this.mLastModified = file.lastModified();
        this.mLength = file.length();
    }

    long getLastModified() {
        return this.mLastModified;
    }

    long getLength() {
        return this.mLength;
    }

    File getFile() {
        return this.mFile;
    }

    String getSha1() {
        try {
            return this.computeAndReturnSha1();
        }
        catch (Sha1Exception e) {
            return null;
        }
    }

    private boolean checkValidity() {
        if (this.mLastModified != this.mFile.lastModified()) {
            this.mLength = this.mFile.length();
            this.mSha1 = null;
            return true;
        }
        return false;
    }

    public boolean isDifferentThan(FileEntity fileEntity) {
        assert (fileEntity.mFile.equals(this.mFile));
        if (this.mLastModified == fileEntity.mLastModified) {
            return false;
        }
        try {
            return this.mLength != fileEntity.mLength || !this.computeAndReturnSha1().equals(fileEntity.computeAndReturnSha1());
        }
        catch (Sha1Exception e) {
            return true;
        }
    }

    private String computeAndReturnSha1() throws Sha1Exception {
        if (this.mSha1 == null) {
            this.mSha1 = FileEntity.getSha1(this.mFile);
        }
        return this.mSha1;
    }

    static String getSha1(File f) throws Sha1Exception {
        byte[] byArray = sBuffer;
        synchronized (sBuffer) {
            try {
                HashCode value = ByteStreams.hash(Files.newInputStreamSupplier(f), Hashing.sha1());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return value.toString();
            }
            catch (Exception e) {
                throw new Sha1Exception(f, (Throwable)e);
            }
        }
    }

    public String toString() {
        return "FileEntity{mFile=" + this.mFile + ", mLastModified=" + this.mLastModified + ", mLength=" + this.mLength + ", mSha1='" + this.mSha1 + '\'' + '}';
    }

    private static final class Sha1Exception
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final File file;

        public Sha1Exception(File jarFile, Throwable cause) {
            super(cause);
            this.file = jarFile;
        }

        public File getJarFile() {
            return this.file;
        }
    }
}

