/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.android.annotations.NonNull;
import com.android.builder.internal.incremental.FileEntity;
import com.android.builder.resources.FileStatus;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FileManager {
    private static final Pattern READ_PATTERN = Pattern.compile("^(\\d+)\\s+(\\d+)\\s+([0-9a-f]+)\\s+(.+)$");
    private Map<File, FileEntity> mLoadedFiles = Maps.newHashMap();
    private Map<File, FileEntity> mProcessedFiles = Maps.newHashMap();
    private Map<File, FileStatus> mResults = Maps.newHashMap();
    private Map<File, FileStatus> mReturnedMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(File stateFile) {
        boolean bl;
        if (!stateFile.exists()) {
            return false;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stateFile), Charsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (line.charAt(0) == '#' || !(m = READ_PATTERN.matcher(line)).matches()) continue;
                String path = m.group(4);
                File f = new File(path);
                FileEntity entity = new FileEntity(f, Long.parseLong(m.group(1)), Long.parseLong(m.group(2)), m.group(3));
                this.mLoadedFiles.put(f, entity);
            }
            bl = true;
        }
        catch (FileNotFoundException ignored) {
            Closeables.closeQuietly(reader);
            return false;
            catch (UnsupportedEncodingException ignored2) {
                Closeables.closeQuietly(reader);
                return false;
                catch (IOException iOException) {
                    Closeables.closeQuietly(reader);
                    return false;
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(reader);
                        throw throwable;
                    }
                }
            }
        }
        Closeables.closeQuietly(reader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File stateFile) throws IOException {
        OutputStreamWriter writer = null;
        try {
            File parentFolder = stateFile.getParentFile();
            if (!parentFolder.isDirectory() && !parentFolder.mkdirs()) {
                throw new IOException("Failed to create directory " + parentFolder);
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stateFile), Charsets.UTF_8);
            writer.write("# incremental data. DO NOT EDIT.\n");
            writer.write("# format is <lastModified> <length> <SHA-1> <path>\n");
            writer.write("# Encoding is UTF-8\n");
            for (FileEntity entity : this.mProcessedFiles.values()) {
                String sha1 = entity.getSha1();
                if (sha1 == null) {
                    sha1 = "0123456789012345678901234567890123456789";
                }
                writer.write(String.format("%d %d %s %s\n", entity.getLastModified(), entity.getLength(), sha1, entity.getFile().getAbsolutePath()));
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly(writer);
    }

    public void addFile(File file) {
        this.processFile(file);
    }

    @NonNull
    public Map<File, FileStatus> getChangedFiles() {
        if (this.mReturnedMap == null) {
            this.mReturnedMap = Maps.newHashMap(this.mResults);
            for (File f : this.mLoadedFiles.keySet()) {
                this.mReturnedMap.put(f, FileStatus.REMOVED);
            }
            this.mReturnedMap = Collections.unmodifiableMap(this.mReturnedMap);
        }
        return this.mReturnedMap;
    }

    private void processFile(File file) {
        File[] files;
        if (file.isFile()) {
            if (file.getName().startsWith(".")) {
                return;
            }
            FileEntity newFileEntity = new FileEntity(file);
            FileEntity fileEntity = this.mLoadedFiles.get(file);
            if (fileEntity == null) {
                this.mResults.put(file, FileStatus.NEW);
                this.mProcessedFiles.put(file, newFileEntity);
            } else {
                this.mLoadedFiles.remove(file);
                if (newFileEntity.isDifferentThan(fileEntity)) {
                    this.mResults.put(file, FileStatus.CHANGED);
                    this.mProcessedFiles.put(file, newFileEntity);
                } else {
                    this.mProcessedFiles.put(file, fileEntity);
                }
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                this.processFile(f);
            }
        }
    }

    void update(Collection<File> files) {
        this.mLoadedFiles.clear();
        this.mLoadedFiles.putAll(this.mProcessedFiles);
        this.mResults.clear();
        this.mProcessedFiles.clear();
        for (File f : files) {
            this.processFile(f);
        }
    }
}

