/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.internal.packaging.PackagingUtils;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import java.io.File;
import java.io.IOException;

public class JavaResourceProcessor {
    private final IArchiveBuilder mBuilder;

    public JavaResourceProcessor(IArchiveBuilder builder) {
        this.mBuilder = builder;
    }

    public void addSourceFolder(String sourceLocation) throws PackagerException, DuplicateFileException, SealedPackageException {
        File sourceFolder = new File(sourceLocation);
        if (sourceFolder.isDirectory()) {
            try {
                File[] files;
                for (File file : files = sourceFolder.listFiles()) {
                    this.processFileForResource(file, null);
                }
            }
            catch (DuplicateFileException e) {
                throw e;
            }
            catch (SealedPackageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PackagerException(e, "Failed to add %s", sourceFolder);
            }
        } else if (sourceFolder.exists()) {
            throw new PackagerException("%s is not a folder", sourceFolder);
        }
    }

    private void processFileForResource(File file, String path) throws IOException, DuplicateFileException, PackagerException, SealedPackageException {
        if (file.isDirectory()) {
            if (PackagingUtils.checkFolderForPackaging(file.getName())) {
                File[] files;
                path = path == null ? file.getName() : path + "/" + file.getName();
                for (File contentFile : files = file.listFiles()) {
                    this.processFileForResource(contentFile, path);
                }
            }
        } else if (PackagingUtils.checkFileForPackaging(file.getName())) {
            path = path == null ? file.getName() : path + "/" + file.getName();
            this.mBuilder.addFile(file, path);
        }
    }

    public static interface IArchiveBuilder {
        public void addFile(File var1, String var2) throws PackagerException, SealedPackageException, DuplicateFileException;
    }
}

