/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.annotations.NonNull;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.PackagingUtils;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.signing.CertificateInfo;
import com.android.builder.signing.SignedJarBuilder;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public final class Packager
implements JavaResourceProcessor.IArchiveBuilder {
    private static final Pattern PATTERN_NATIVELIB_EXT = Pattern.compile("^.+\\.so$", 2);
    private SignedJarBuilder mBuilder = null;
    private final ILogger mLogger;
    private boolean mJniDebugMode = false;
    private boolean mIsSealed = false;
    private final NullZipFilter mNullFilter = new NullZipFilter();
    private final JavaAndNativeResourceFilter mFilter = new JavaAndNativeResourceFilter();
    private final HashMap<String, File> mAddedFiles = new HashMap();

    public Packager(@NonNull String apkLocation, @NonNull String resLocation, @NonNull String dexLocation, CertificateInfo certificateInfo, ILogger logger) throws PackagerException {
        try {
            File apkFile = new File(apkLocation);
            this.checkOutputFile(apkFile);
            File resFile = new File(resLocation);
            Packager.checkInputFile(resFile);
            File dexFile = null;
            if (dexLocation != null) {
                dexFile = new File(dexLocation);
                Packager.checkInputFile(dexFile);
            }
            this.mLogger = logger;
            this.mBuilder = new SignedJarBuilder(new FileOutputStream(apkFile, false), certificateInfo != null ? certificateInfo.getKey() : null, certificateInfo != null ? certificateInfo.getCertificate() : null);
            this.mLogger.verbose("Packaging %s", apkFile.getName());
            this.addZipFile(resFile);
            if (dexFile != null) {
                this.addFile(dexFile, "classes.dex");
            }
        }
        catch (PackagerException e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw new PackagerException(e);
        }
    }

    public void setJniDebugMode(boolean jniDebugMode) {
        this.mJniDebugMode = jniDebugMode;
    }

    @Override
    public void addFile(File file, String archivePath) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.doAddFile(file, archivePath);
        }
        catch (DuplicateFileException e) {
            this.mBuilder.cleanUp();
            throw e;
        }
        catch (Exception e) {
            this.mBuilder.cleanUp();
            throw new PackagerException(e, "Failed to add %s", file);
        }
    }

    void addZipFile(File zipFile) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.mLogger.verbose("%s:", zipFile);
            this.mNullFilter.reset(zipFile);
            FileInputStream fis = new FileInputStream(zipFile);
            this.mBuilder.writeZip(fis, this.mNullFilter);
        }
        catch (DuplicateFileException e) {
            this.mBuilder.cleanUp();
            throw e;
        }
        catch (Exception e) {
            this.mBuilder.cleanUp();
            throw new PackagerException(e, "Failed to add %s", zipFile);
        }
    }

    public JarStatus addResourcesFromJar(File jarFile) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.mLogger.verbose("%s:", jarFile);
            this.mFilter.reset(jarFile);
            FileInputStream fis = new FileInputStream(jarFile);
            this.mBuilder.writeZip(fis, this.mFilter);
            return new JarStatusImpl(this.mFilter.getNativeLibs(), this.mFilter.getNativeLibsConflict());
        }
        catch (DuplicateFileException e) {
            this.mBuilder.cleanUp();
            throw e;
        }
        catch (Exception e) {
            this.mBuilder.cleanUp();
            throw new PackagerException(e, "Failed to add %s", jarFile);
        }
    }

    public void addNativeLibraries(String jniLibLocation) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        File nativeFolder = new File(jniLibLocation);
        if (!nativeFolder.isDirectory()) {
            if (nativeFolder.exists()) {
                throw new PackagerException("%s is not a folder", nativeFolder);
            }
            throw new PackagerException("%s does not exist", nativeFolder);
        }
        File[] abiList = nativeFolder.listFiles();
        this.mLogger.verbose("Native folder: %s", nativeFolder);
        if (abiList != null) {
            for (File abi : abiList) {
                File[] libs;
                if (!abi.isDirectory() || (libs = abi.listFiles()) == null) continue;
                for (File lib : libs) {
                    if (!lib.isFile() || !PATTERN_NATIVELIB_EXT.matcher(lib.getName()).matches() && (!this.mJniDebugMode || !"gdbserver".equals(lib.getName()))) continue;
                    String path = "lib/" + abi.getName() + "/" + lib.getName();
                    try {
                        this.doAddFile(lib, path);
                    }
                    catch (IOException e) {
                        this.mBuilder.cleanUp();
                        throw new PackagerException(e, "Failed to add %s", lib);
                    }
                }
            }
        }
    }

    public void sealApk() throws PackagerException, SealedPackageException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.mBuilder.close();
            this.mIsSealed = true;
        }
        catch (Exception e) {
            throw new PackagerException(e, "Failed to seal APK", new Object[0]);
        }
        finally {
            this.mBuilder.cleanUp();
        }
    }

    private void doAddFile(File file, String archivePath) throws DuplicateFileException, IOException {
        this.mLogger.verbose("%1$s => %2$s", file, archivePath);
        File duplicate = this.checkFileForDuplicate(archivePath);
        if (duplicate != null) {
            throw new DuplicateFileException(archivePath, duplicate, file);
        }
        this.mAddedFiles.put(archivePath, file);
        this.mBuilder.writeFile(file, archivePath);
    }

    private File checkFileForDuplicate(String archivePath) {
        return this.mAddedFiles.get(archivePath);
    }

    private void checkOutputFile(File file) throws PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new PackagerException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new PackagerException("Failed to create %s", file);
                }
            }
            catch (IOException e) {
                throw new PackagerException("Failed to create '%1$ss': %2$s", file, e.getMessage());
            }
        }
    }

    private static void checkInputFile(File file) throws FileNotFoundException, PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new PackagerException("Cannot read %s", file);
            }
        } else {
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
    }

    private static final class JarStatusImpl
    implements JarStatus {
        public final List<String> mLibs;
        public final boolean mNativeLibsConflict;

        private JarStatusImpl(List<String> libs, boolean nativeLibsConflict) {
            this.mLibs = libs;
            this.mNativeLibsConflict = nativeLibsConflict;
        }

        @Override
        public List<String> getNativeLibs() {
            return this.mLibs;
        }

        @Override
        public boolean hasNativeLibsConflicts() {
            return this.mNativeLibsConflict;
        }
    }

    public static interface JarStatus {
        public List<String> getNativeLibs();

        public boolean hasNativeLibsConflicts();
    }

    private final class JavaAndNativeResourceFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final List<String> mNativeLibs = new ArrayList<String>();
        private boolean mNativeLibsConflict = false;
        private File mInputFile;

        private JavaAndNativeResourceFilter() {
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            String[] segments = archivePath.split("/");
            if (segments.length == 0) {
                return false;
            }
            for (int i = 0; i < segments.length - 1; ++i) {
                if (PackagingUtils.checkFolderForPackaging(segments[i])) continue;
                return false;
            }
            String fileName = segments[segments.length - 1];
            boolean check = PackagingUtils.checkFileForPackaging(fileName);
            if (check) {
                Packager.this.mLogger.verbose("=> %s", archivePath);
                File duplicate = Packager.this.checkFileForDuplicate(archivePath);
                if (duplicate != null) {
                    throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
                }
                Packager.this.mAddedFiles.put(archivePath, this.mInputFile);
                if (archivePath.endsWith(".so")) {
                    this.mNativeLibs.add(archivePath);
                    if (archivePath.startsWith("lib/")) {
                        this.mNativeLibsConflict = true;
                    }
                } else if (archivePath.endsWith(".jnilib")) {
                    this.mNativeLibs.add(archivePath);
                }
            }
            return check;
        }

        List<String> getNativeLibs() {
            return this.mNativeLibs;
        }

        boolean getNativeLibsConflict() {
            return this.mNativeLibsConflict;
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
            this.mNativeLibs.clear();
            this.mNativeLibsConflict = false;
        }
    }

    private final class NullZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private File mInputFile;

        private NullZipFilter() {
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            Packager.this.mLogger.verbose("=> %s", archivePath);
            File duplicate = Packager.this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
            }
            Packager.this.mAddedFiles.put(archivePath, this.mInputFile);
            return true;
        }
    }
}

