/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.util.concurrent;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class WaitableExecutor<T> {
    private final CompletionService<T> mCompletionService = new ExecutorCompletionService<T>(Executors.newCachedThreadPool());
    private int mCount = 0;

    public void execute(Callable<T> runnable) {
        this.mCompletionService.submit(runnable);
        ++this.mCount;
    }

    public List<T> waitForTasks() throws InterruptedException, ExecutionException {
        ArrayList<T> results = Lists.newArrayListWithCapacity(this.mCount);
        for (int i = 0; i < this.mCount; ++i) {
            Future<T> result = this.mCompletionService.take();
            results.add(result.get());
        }
        return results;
    }
}

