/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.internal.util.concurrent.WaitableExecutor;
import com.android.builder.resources.AssetFile;
import com.android.builder.resources.AssetItem;
import com.android.builder.resources.AssetSet;
import com.android.builder.resources.DataMerger;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.w3c.dom.Node;

public class AssetMerger
extends DataMerger<AssetItem, AssetFile, AssetSet> {
    @Override
    protected void removeItem(File rootFolder, AssetItem item, AssetItem replacedBy) {
        if (replacedBy == null) {
            File removedFile = new File(rootFolder, item.getName());
            removedFile.delete();
        }
    }

    @Override
    protected void writeItem(final @NonNull File rootFolder, final @NonNull AssetItem item, @NonNull WaitableExecutor executor) throws IOException {
        if (item.isTouched()) {
            executor.execute(new Callable(){

                public Object call() throws Exception {
                    AssetFile assetFile = (AssetFile)item.getSource();
                    File file = assetFile.getFile();
                    String filename = file.getName();
                    File outFile = new File(rootFolder, filename);
                    Files.copy(file, outFile);
                    return null;
                }
            });
        }
    }

    @Override
    protected AssetSet createFromXml(Node node) {
        AssetSet set = new AssetSet("");
        return (AssetSet)set.createFromXml(node);
    }

    @Override
    protected void postWriteDataFolder(File rootFolder) throws IOException {
    }
}

