/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.builder.resources.AssetFile;
import com.android.builder.resources.AssetItem;
import com.android.builder.resources.DataSet;
import com.android.builder.resources.DuplicateDataException;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AssetSet
extends DataSet<AssetItem, AssetFile> {
    public AssetSet(String configName) {
        super(configName);
    }

    @Override
    protected DataSet<AssetItem, AssetFile> createSet(String name) {
        return new AssetSet(name);
    }

    @Override
    protected AssetFile createFileAndItems(File file, ILogger logger) {
        return new AssetFile(file, new AssetItem(file.getName()));
    }

    @Override
    protected AssetFile createFileAndItems(File file, Node fileNode) {
        Attr nameAttr = (Attr)fileNode.getAttributes().getNamedItem("name");
        if (nameAttr == null) {
            return null;
        }
        AssetItem item = new AssetItem(nameAttr.getValue());
        return new AssetFile(file, item);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file) {
        return file.getParentFile().equals(sourceFolder);
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws DuplicateDataException, IOException {
        File[] files = sourceFolder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile() || !this.checkFileForAndroidRes(file)) continue;
                this.handleNewFile(sourceFolder, file, logger);
            }
        }
    }
}

