/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.resources.DataItem;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataFile<I extends DataItem> {
    private final FileType mType;
    private final File mFile;
    private final Map<String, I> mItems;

    DataFile(@NonNull File file, @NonNull I item) {
        this.mType = FileType.SINGLE;
        this.mFile = file;
        ((DataItem)item).setSource((DataFile)this);
        this.mItems = Collections.singletonMap(((DataItem)item).getKey(), item);
    }

    DataFile(@NonNull File file, @NonNull List<I> items) {
        this.mType = FileType.MULTI;
        this.mFile = file;
        this.mItems = Maps.newHashMapWithExpectedSize(items.size());
        for (DataItem item : items) {
            item.setSource(this);
            this.mItems.put(item.getKey(), item);
        }
    }

    @NonNull
    FileType getType() {
        return this.mType;
    }

    @NonNull
    File getFile() {
        return this.mFile;
    }

    I getItem() {
        assert (this.mItems.size() == 1);
        return (I)((DataItem)this.mItems.values().iterator().next());
    }

    @NonNull
    Collection<I> getItems() {
        return this.mItems.values();
    }

    @NonNull
    Map<String, I> getItemMap() {
        return this.mItems;
    }

    void addItems(Collection<I> items) {
        for (DataItem item : items) {
            this.mItems.put(item.getKey(), item);
            item.setSource(this);
        }
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    static enum FileType {
        SINGLE,
        MULTI;

    }
}

