/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.resources.DataFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataItem<F extends DataFile> {
    private static final int MASK_TOUCHED = 1;
    private static final int MASK_REMOVED = 2;
    private static final int MASK_WRITTEN = 16;
    private final String mName;
    private F mSource;
    private int mStatus = 0;

    DataItem(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public F getSource() {
        return this.mSource;
    }

    void setSource(F sourceFile) {
        this.mSource = sourceFile;
    }

    DataItem resetStatusToWritten() {
        this.mStatus = 16;
        return this;
    }

    DataItem setWritten() {
        this.mStatus |= 0x10;
        return this;
    }

    DataItem setRemoved() {
        this.mStatus |= 2;
        return this;
    }

    DataItem setTouched() {
        this.mStatus |= 1;
        return this;
    }

    boolean isRemoved() {
        return (this.mStatus & 2) != 0;
    }

    boolean isTouched() {
        return (this.mStatus & 1) != 0;
    }

    boolean isWritten() {
        return (this.mStatus & 0x10) != 0;
    }

    protected int getStatus() {
        return this.mStatus;
    }

    String getKey() {
        return this.mName;
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    Node getAdoptedNode(Document document) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataItem resource = (DataItem)o;
        return this.mName.equals(resource.mName);
    }

    public int hashCode() {
        return this.mName.hashCode();
    }
}

