/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.internal.util.concurrent.WaitableExecutor;
import com.android.builder.resources.DataFile;
import com.android.builder.resources.DataItem;
import com.android.builder.resources.DataMap;
import com.android.builder.resources.DataSet;
import com.android.builder.resources.DuplicateDataException;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class DataMerger<I extends DataItem<F>, F extends DataFile<I>, S extends DataSet<I, F>>
implements DataMap<I> {
    static final String FN_MERGER_XML = "merger.xml";
    private static final String NODE_MERGER = "merger";
    private static final String NODE_DATA_SET = "dataSet";
    private final List<S> mDataSets = Lists.newArrayList();

    protected abstract void postWriteDataFolder(File var1) throws IOException;

    protected abstract void removeItem(File var1, I var2, I var3);

    protected abstract void writeItem(@NonNull File var1, @NonNull I var2, @NonNull WaitableExecutor var3) throws IOException;

    protected abstract S createFromXml(Node var1);

    public void addDataSet(S resourceSet) {
        this.mDataSets.add(resourceSet);
    }

    List<S> getDataSets() {
        return this.mDataSets;
    }

    void validateDataSets() throws DuplicateDataException {
        for (DataSet resourceSet : this.mDataSets) {
            resourceSet.checkItems();
        }
    }

    @Override
    public int size() {
        HashSet keys = Sets.newHashSet();
        for (DataSet resourceSet : this.mDataSets) {
            ListMultimap map = resourceSet.getDataMap();
            keys.addAll(map.keySet());
        }
        return keys.size();
    }

    @Override
    @NonNull
    public ListMultimap<String, I> getDataMap() {
        ArrayListMultimap fullItemMultimap = ArrayListMultimap.create();
        for (DataSet resourceSet : this.mDataSets) {
            ListMultimap map = resourceSet.getDataMap();
            for (Map.Entry entry : map.asMap().entrySet()) {
                fullItemMultimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return fullItemMultimap;
    }

    public void writeDataFolder(@NonNull File rootFolder) throws IOException, DuplicateDataException, ExecutionException, InterruptedException {
        WaitableExecutor executor = new WaitableExecutor();
        HashSet<String> dataItemKeys = Sets.newHashSet();
        for (DataSet dataSet : this.mDataSets) {
            dataSet.checkItems();
            ListMultimap map = dataSet.getDataMap();
            dataItemKeys.addAll(map.keySet());
        }
        for (String dataItemKey : dataItemKeys) {
            DataItem previouslyWritten = null;
            DataItem toWrite = null;
            block2: for (int i = this.mDataSets.size() - 1; i >= 0; --i) {
                DataSet dataSet = (DataSet)this.mDataSets.get(i);
                ListMultimap itemMap = dataSet.getDataMap();
                List items = itemMap.get(dataItemKey);
                if (items.isEmpty()) continue;
                for (int ii = items.size() - 1; ii >= 0; --ii) {
                    DataItem item = (DataItem)items.get(ii);
                    if (item.isWritten()) {
                        assert (previouslyWritten == null);
                        previouslyWritten = item;
                    }
                    if (toWrite == null && !item.isRemoved()) {
                        toWrite = item;
                    }
                    if (toWrite != null && previouslyWritten != null) break block2;
                }
            }
            assert (previouslyWritten != null || toWrite != null);
            if (toWrite == null) {
                assert (previouslyWritten.isRemoved());
                this.removeItem(rootFolder, previouslyWritten, null);
                continue;
            }
            if (previouslyWritten == null || previouslyWritten == toWrite) {
                this.writeItem(rootFolder, toWrite, executor);
                continue;
            }
            toWrite.setTouched();
            this.writeItem(rootFolder, toWrite, executor);
            this.removeItem(rootFolder, previouslyWritten, toWrite);
        }
        this.postWriteDataFolder(rootFolder);
        executor.waitForTasks();
    }

    public void writeBlobTo(File blobRootFolder) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement(NODE_MERGER);
            document.appendChild(rootNode);
            for (DataSet dataSet : this.mDataSets) {
                Element dataSetNode = document.createElement(NODE_DATA_SET);
                rootNode.appendChild(dataSetNode);
                dataSet.appendToXml(dataSetNode, document);
            }
            String content = XmlPrettyPrinter.prettyPrint(document);
            this.createDir(blobRootFolder);
            Files.write(content, new File(blobRootFolder, FN_MERGER_XML), Charsets.UTF_8);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    public boolean loadFromBlob(File blobRootFolder) throws IOException {
        boolean bl;
        File file = new File(blobRootFolder, FN_MERGER_XML);
        if (!file.isFile()) {
            return false;
        }
        BufferedInputStream stream = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            stream = new BufferedInputStream(new FileInputStream(file));
            InputSource is = new InputSource(stream);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            Element rootNode = document.getDocumentElement();
            if (rootNode == null || !NODE_MERGER.equals(rootNode.getLocalName())) {
                boolean bl2 = false;
                return bl2;
            }
            NodeList nodes = rootNode.getChildNodes();
            int n = nodes.getLength();
            for (int i = 0; i < n; ++i) {
                S dataSet;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !NODE_DATA_SET.equals(node.getLocalName()) || (dataSet = this.createFromXml(node)) == null) continue;
                this.mDataSets.add(dataSet);
            }
            this.setItemsToWritten();
            bl = true;
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return bl;
    }

    private void setItemsToWritten() {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        for (DataSet dataSet : this.mDataSets) {
            ListMultimap map = dataSet.getDataMap();
            for (Map.Entry entry : map.asMap().entrySet()) {
                itemMap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        for (String key : itemMap.keySet()) {
            List itemList = itemMap.get(key);
            ((DataItem)itemList.get(itemList.size() - 1)).resetStatusToWritten();
        }
    }

    public boolean checkValidUpdate(List<S> dataSets) {
        if (dataSets.size() != this.mDataSets.size()) {
            return false;
        }
        int n = dataSets.size();
        for (int i = 0; i < n; ++i) {
            DataSet localSet = (DataSet)this.mDataSets.get(i);
            DataSet newSet = (DataSet)dataSets.get(i);
            List<File> localSourceFiles = localSet.getSourceFiles();
            List<File> newSourceFiles = newSet.getSourceFiles();
            if (!newSet.getConfigName().equals(localSet.getConfigName()) || localSourceFiles.size() != newSourceFiles.size()) {
                return false;
            }
            localSourceFiles = Lists.newArrayList(localSourceFiles);
            Collections.sort(localSourceFiles);
            newSourceFiles = Lists.newArrayList(newSourceFiles);
            Collections.sort(newSourceFiles);
            if (((Object)localSourceFiles).equals(newSourceFiles)) continue;
            return false;
        }
        return true;
    }

    public Pair<S, File> getDataSetContaining(File file) {
        for (DataSet dataSet : this.mDataSets) {
            File sourceFile = dataSet.findMatchingSourceFile(file);
            if (file == null) continue;
            return Pair.of(dataSet, sourceFile);
        }
        return null;
    }

    protected synchronized void createDir(File folder) throws IOException {
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Failed to create directory: " + folder);
        }
    }

    public String toString() {
        return Arrays.toString(this.mDataSets.toArray());
    }
}

