/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.builder.resources.DataFile;
import com.android.builder.resources.DataItem;
import com.android.builder.resources.DataMap;
import com.android.builder.resources.DuplicateDataException;
import com.android.builder.resources.FileStatus;
import com.android.builder.resources.NodeUtils;
import com.android.builder.resources.SourceSet;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class DataSet<I extends DataItem<F>, F extends DataFile<I>>
implements SourceSet,
DataMap<I> {
    static final String NODE_SOURCE = "source";
    static final String NODE_FILE = "file";
    static final String ATTR_CONFIG = "config";
    static final String ATTR_PATH = "path";
    static final String ATTR_NAME = "name";
    private final String mConfigName;
    private final List<File> mSourceFiles = Lists.newArrayList();
    private final ListMultimap<String, I> mItems = ArrayListMultimap.create();
    private final ListMultimap<File, F> mSourceFileToDataFilesMap = ArrayListMultimap.create();
    private final Map<File, F> mDataFileMap = Maps.newHashMap();

    public DataSet(String configName) {
        this.mConfigName = configName;
    }

    protected abstract DataSet<I, F> createSet(String var1);

    protected abstract F createFileAndItems(File var1, Node var2);

    protected abstract void readSourceFolder(File var1, ILogger var2) throws DuplicateDataException, IOException;

    protected abstract F createFileAndItems(File var1, ILogger var2) throws IOException;

    public void addSources(Collection<File> files) {
        this.mSourceFiles.addAll(files);
    }

    public void addSource(File file) {
        this.mSourceFiles.add(file);
    }

    @Override
    @NonNull
    public List<File> getSourceFiles() {
        return this.mSourceFiles;
    }

    public String getConfigName() {
        return this.mConfigName;
    }

    @Override
    public File findMatchingSourceFile(File file) {
        for (File sourceFile : this.mSourceFiles) {
            if (sourceFile.equals(file)) {
                return sourceFile;
            }
            if (!sourceFile.isDirectory()) continue;
            String sourcePath = sourceFile.getAbsolutePath() + File.separator;
            if (!file.getAbsolutePath().startsWith(sourcePath)) continue;
            return sourceFile;
        }
        return null;
    }

    @Override
    public int size() {
        return this.mItems.keySet().size();
    }

    public boolean isEmpty() {
        return this.mItems.isEmpty();
    }

    @Override
    @NonNull
    public ListMultimap<String, I> getDataMap() {
        return this.mItems;
    }

    public void loadFromFiles(ILogger logger) throws DuplicateDataException, IOException {
        for (File file : this.mSourceFiles) {
            if (file.isDirectory()) {
                this.readSourceFolder(file, logger);
                continue;
            }
            if (!file.isFile()) continue;
        }
        this.checkItems();
    }

    void appendToXml(Node setNode, Document document) {
        NodeUtils.addAttribute(document, setNode, null, ATTR_CONFIG, this.mConfigName);
        for (File sourceFile : this.mSourceFiles) {
            Element sourceNode = document.createElement(NODE_SOURCE);
            setNode.appendChild(sourceNode);
            NodeUtils.addAttribute(document, sourceNode, null, ATTR_PATH, sourceFile.getAbsolutePath());
            List<F> dataFiles = this.mSourceFileToDataFilesMap.get(sourceFile);
            for (DataFile dataFile : dataFiles) {
                Element fileNode = document.createElement(NODE_FILE);
                sourceNode.appendChild(fileNode);
                NodeUtils.addAttribute(document, fileNode, null, ATTR_PATH, dataFile.getFile().getAbsolutePath());
                dataFile.addExtraAttributes(document, fileNode, null);
                if (dataFile.getType() == DataFile.FileType.MULTI) {
                    for (DataItem item : dataFile.getItems()) {
                        Node adoptedNode = item.getAdoptedNode(document);
                        if (adoptedNode == null) continue;
                        fileNode.appendChild(adoptedNode);
                    }
                    continue;
                }
                Object dataItem = dataFile.getItem();
                NodeUtils.addAttribute(document, fileNode, null, ATTR_NAME, ((DataItem)dataItem).getName());
                ((DataItem)dataItem).addExtraAttributes(document, fileNode, null);
            }
        }
    }

    DataSet<I, F> createFromXml(Node dataSetNode) {
        Attr configNameAttr = (Attr)dataSetNode.getAttributes().getNamedItem(ATTR_CONFIG);
        if (configNameAttr == null) {
            return null;
        }
        DataSet<I, F> dataSet = this.createSet(configNameAttr.getValue());
        NodeList sourceNodes = dataSetNode.getChildNodes();
        int n = sourceNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr pathAttr;
            Node sourceNode = sourceNodes.item(i);
            if (sourceNode.getNodeType() != 1 || !NODE_SOURCE.equals(sourceNode.getLocalName()) || (pathAttr = (Attr)sourceNode.getAttributes().getNamedItem(ATTR_PATH)) == null) continue;
            File sourceFolder = new File(pathAttr.getValue());
            dataSet.mSourceFiles.add(sourceFolder);
            NodeList fileNodes = sourceNode.getChildNodes();
            int m = fileNodes.getLength();
            for (int j = 0; j < m; ++j) {
                F dataFile;
                Node fileNode = fileNodes.item(j);
                if (fileNode.getNodeType() != 1 || !NODE_FILE.equals(fileNode.getLocalName()) || (pathAttr = (Attr)fileNode.getAttributes().getNamedItem(ATTR_PATH)) == null || (dataFile = this.createFileAndItems(new File(pathAttr.getValue()), fileNode)) == null) continue;
                dataSet.processNewDataFile(sourceFolder, dataFile, false);
            }
        }
        return dataSet;
    }

    void checkItems() throws DuplicateDataException {
        for (Map.Entry<String, Collection<I>> entry : this.mItems.asMap().entrySet()) {
            Collection<I> items = entry.getValue();
            DataItem lastItem = null;
            for (DataItem item : items) {
                if (item.isRemoved()) continue;
                if (lastItem == null) {
                    lastItem = item;
                    continue;
                }
                throw new DuplicateDataException(item, lastItem);
            }
        }
    }

    public boolean updateWith(File sourceFolder, File changedFile, FileStatus fileStatus, ILogger logger) throws IOException {
        switch (fileStatus) {
            case NEW: {
                if (this.isValidSourceFile(sourceFolder, changedFile)) {
                    return this.handleNewFile(sourceFolder, changedFile, logger);
                }
                return true;
            }
            case CHANGED: {
                return this.handleChangedFile(sourceFolder, changedFile);
            }
            case REMOVED: {
                DataFile dataFile = (DataFile)this.mDataFileMap.get(changedFile);
                for (DataItem dataItem : dataFile.getItems()) {
                    dataItem.setRemoved();
                }
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isValidSourceFile(File var1, File var2);

    protected boolean handleNewFile(File sourceFolder, File file, ILogger logger) throws IOException {
        F dataFile = this.createFileAndItems(file, logger);
        this.processNewDataFile(sourceFolder, dataFile, true);
        return true;
    }

    protected void processNewDataFile(File sourceFolder, F dataFile, boolean setTouched) {
        Collection dataItems = ((DataFile)dataFile).getItems();
        this.addDataFile(sourceFolder, dataFile);
        for (DataItem dataItem : dataItems) {
            this.mItems.put(dataItem.getKey(), dataItem);
            if (!setTouched) continue;
            dataItem.setTouched();
        }
    }

    protected boolean handleChangedFile(File sourceFolder, File changedFile) throws IOException {
        DataFile dataFile = (DataFile)this.mDataFileMap.get(changedFile);
        ((DataItem)dataFile.getItem()).setTouched();
        return true;
    }

    protected void addItem(I item, String key) {
        if (key == null) {
            key = ((DataItem)item).getKey();
        }
        this.mItems.put(key, item);
    }

    protected F getDataFile(File file) {
        return (F)((DataFile)this.mDataFileMap.get(file));
    }

    private void addDataFile(File sourceFile, F dataFile) {
        this.mSourceFileToDataFilesMap.put(sourceFile, dataFile);
        this.mDataFileMap.put(((DataFile)dataFile).getFile(), dataFile);
    }

    public String toString() {
        return Arrays.toString(this.mSourceFiles.toArray());
    }

    protected boolean checkFileForAndroidRes(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        String extension = "";
        if (pos != -1) {
            extension = name.substring(pos + 1);
        }
        return name.charAt(0) != '.' && name.charAt(name.length() - 1) != '~' && !"scc".equalsIgnoreCase(extension) && !"swp".equalsIgnoreCase(extension) && !"thumbs.db".equalsIgnoreCase(name) && !"picasa.ini".equalsIgnoreCase(name);
    }
}

