/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.resources.DataFile;
import com.android.builder.resources.NodeUtils;
import com.android.builder.resources.ResourceItem;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ResourceFile
extends DataFile<ResourceItem> {
    static final String ATTR_QUALIFIER = "qualifiers";
    static final String ATTR_TYPE = "type";
    private final String mQualifiers;

    ResourceFile(@NonNull File file, @NonNull ResourceItem item, @Nullable String qualifiers) {
        super(file, item);
        this.mQualifiers = qualifiers;
    }

    ResourceFile(@NonNull File file, @NonNull List<ResourceItem> items, @Nullable String qualifiers) {
        super(file, items);
        this.mQualifiers = qualifiers;
    }

    @Nullable
    String getQualifiers() {
        return this.mQualifiers;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, namespaceUri, ATTR_QUALIFIER, this.getQualifiers());
    }
}

